/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="crystal_tools")
public class LevelTickEvent {
    public static ConcurrentHashMap<ResourceKey<Level>, Set<TrackingProjectileData>> TRACKING_PROJECTILES = new ConcurrentHashMap();

    @SubscribeEvent
    public static void handleLevelTick(LevelTickEvent.Pre event) {
        block5: {
            Level level = event.getLevel();
            if (level.getGameTime() % 5L != 0L || !(level instanceof ServerLevel)) break block5;
            Set<TrackingProjectileData> projectiles = TRACKING_PROJECTILES.get(level.dimension());
            if (projectiles == null) {
                return;
            }
            Iterator<TrackingProjectileData> iterator = projectiles.iterator();
            while (iterator.hasNext()) {
                block6: {
                    Projectile projectileEntity;
                    Entity target;
                    TrackingProjectileData projectileData;
                    block7: {
                        AbstractArrow arrow;
                        projectileData = iterator.next();
                        Entity projectile = level.getEntity(projectileData.projectileId);
                        target = level.getEntity(projectileData.targetId);
                        if (projectile == null || target == null || projectile.isRemoved() || target.isRemoved() || !(projectile instanceof Projectile) || (projectileEntity = (Projectile)projectile) instanceof AbstractArrow && (arrow = (AbstractArrow)projectileEntity).isInGround()) break block6;
                        if (!(projectileEntity instanceof ThrownTrident)) break block7;
                        ThrownTrident trident = (ThrownTrident)projectileEntity;
                        if (trident.dealtDamage) break block6;
                    }
                    double speed = Math.max(projectileData.initialSpeed, 1.0);
                    projectileEntity.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
                    projectileEntity.setNoGravity(true);
                    projectileEntity.setDeltaMovement(target.trackingPosition().subtract(projectileEntity.position()).normalize().scale(speed));
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static void startTracking(Level level, int projectileId, int targetId, double initialSpeed) {
        Set data = TRACKING_PROJECTILES.getOrDefault(level.dimension(), new HashSet());
        data.add(new TrackingProjectileData(projectileId, targetId, initialSpeed));
        TRACKING_PROJECTILES.put((ResourceKey<Level>)level.dimension(), data);
    }

    public record TrackingProjectileData(int projectileId, int targetId, double initialSpeed) {
    }
}

