/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.events;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.capability.LevelableStack;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="crystal_tools")
public class LivingHurtEvent {
    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingDamageEvent.Post event) {
        ItemStack stack;
        Object object;
        Player player;
        LivingEntity target = event.getEntity();
        float damageAmount = event.getOriginalDamage();
        if (target instanceof Player) {
            player = (Player)target;
            object = InventoryUtils.getArmorItems(player).iterator();
            while (object.hasNext()) {
                ItemStack armor = (ItemStack)object.next();
                Levelable levelable = (Levelable)armor.getCapability(Capabilities.ITEM_SKILL, (Object)player.level().registryAccess());
                if (levelable == null) continue;
                levelable.addExp(player.level(), player.getOnPos(), (LivingEntity)player, damageAmount);
            }
        }
        if ((object = event.getSource().getEntity()) instanceof Player && !(stack = (player = (Player)object).getWeaponItem()).isEmpty() && !ToolUtils.isBroken(stack)) {
            LevelableStack levelable = (LevelableStack)stack.getCapability(Capabilities.ITEM_SKILL, (Object)player.level().registryAccess());
            if (levelable == null) {
                return;
            }
            if (((Boolean)stack.getOrDefault(DataComponents.FIRE, (Object)false)).booleanValue()) {
                target.igniteForSeconds(8.0f);
            }
            if (ToolUtils.isValidEntity(target)) {
                int heal = (Integer)stack.getOrDefault(DataComponents.LIFESTEAL, (Object)0);
                if (heal > 0) {
                    player.heal((float)heal);
                }
                if (levelable.allowDamageXp()) {
                    levelable.addExp(player.level(), player.getOnPos(), (LivingEntity)player, damageAmount);
                }
            }
        }
    }
}

