/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import java.util.function.BiConsumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CallbackItemStackHandler
extends ItemStackHandler {
    private final BiConsumer<ItemStack, ItemStack> callback;

    public CallbackItemStackHandler(NonNullList<ItemStack> stacks, BiConsumer<ItemStack, ItemStack> callback) {
        super(stacks);
        this.callback = callback;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack originalStack = this.getStackInSlot(slot);
        super.setStackInSlot(slot, stack);
        this.callback.accept(stack, originalStack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack originalStack = this.getStackInSlot(slot);
        ItemStack result = super.insertItem(slot, stack, simulate);
        if (!simulate) {
            this.callback.accept(stack, originalStack);
        }
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack result = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            this.callback.accept(this.getStackInSlot(slot), result);
        }
        return result;
    }
}

