/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class CompressionItemStackHandler
extends ComponentItemHandler {
    private List<CompressionMode> slotModes;

    public CompressionItemStackHandler(ItemStack stack, DataComponentType<ItemContainerContents> component, int size) {
        super((MutableDataComponentHolder)stack, component, size);
        this.slotModes = new ArrayList<CompressionMode>(size / 2);
        List storedSlotModes = (List)stack.getOrDefault(DataComponents.COMPRESSION_MODES, new ArrayList());
        for (Integer storedSlotMode : storedSlotModes) {
            this.slotModes.add(CompressionMode.fromInt(storedSlotMode));
        }
        for (int i = storedSlotModes.size(); i < size / 2; ++i) {
            this.slotModes.add(CompressionMode.NONE);
        }
    }

    public CompressionMode getMode(int slot) {
        return this.slotModes.get(slot / 2);
    }

    public void setMode(CompressionMode mode, int slot) {
        this.slotModes.set(slot / 2, mode);
        this.parent.set(DataComponents.COMPRESSION_MODES, this.slotModes.stream().map(CompressionMode::toInt).toList());
    }

    public static enum CompressionMode {
        THREE_BY_THREE(9),
        TWO_BY_TWO(4),
        NONE(0);

        private final int count;

        private CompressionMode(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public int toInt() {
            return this.ordinal();
        }

        public static CompressionMode fromInt(int value) {
            return CompressionMode.values()[value];
        }
    }
}

