/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.inventory;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.datamap.GeneratorFuelData;
import dev.willyelton.crystal_tools.common.inventory.ListComponentItemHandler;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalGeneratorBlockEntity;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class PortableGeneratorInventory
extends ListComponentItemHandler {
    public static final int MAX_SIZE = 27;
    private final ItemStack generatorStack;
    @Nullable
    private Level level;

    public PortableGeneratorInventory(int size) {
        super((MutableDataComponentHolder)ItemStack.EMPTY.copy(), (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), Math.min(size, 27));
        this.generatorStack = ItemStack.EMPTY.copy();
    }

    public PortableGeneratorInventory(ItemStack stack) {
        super((MutableDataComponentHolder)stack, (DataComponentType<List<ItemContainerContents>>)((DataComponentType)DataComponents.BACKPACK_INVENTORY.get()), Math.min((Integer)stack.getOrDefault(DataComponents.PORTABLE_GENERATOR_SLOTS, (Object)0) + 1, 27));
        this.generatorStack = stack;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        boolean canFit;
        if (stack.isEmpty()) {
            return true;
        }
        boolean bl = canFit = !stack.is(Registration.PORTABLE_GENERATOR) && super.isItemValid(slot, stack);
        if (this.level == null) {
            return canFit;
        }
        GeneratorFuelData newFuelData = CrystalGeneratorBlockEntity.getFuelData(stack, (Boolean)this.generatorStack.getOrDefault(DataComponents.FOOD_GENERATOR, (Object)false), (Boolean)this.generatorStack.getOrDefault(DataComponents.METAL_GENERATOR, (Object)false), (Boolean)this.generatorStack.getOrDefault(DataComponents.GEM_GENERATOR, (Object)false));
        return canFit && (newFuelData != null || stack.getBurnTime(RecipeType.SMELTING, this.level.fuelValues()) > 0);
    }

    public ItemStack insertStack(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack, (boolean)false);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ItemStack nextItem() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemStack toReturn = stack.copyWithCount(1);
            ItemStack leftOver = stack.copy();
            leftOver.shrink(1);
            this.setStackInSlot(i, leftOver);
            return toReturn;
        }
        return ItemStack.EMPTY.copy();
    }
}

