/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public record LevelableTooltip(Map<String, Float> skills) {
    public static Codec<LevelableTooltip> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT).xmap(LevelableTooltip::new, LevelableTooltip::skills);
    public static StreamCodec<ByteBuf, LevelableTooltip> STREAM_CODEC = ByteBufCodecs.map(i -> new HashMap(), (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.FLOAT).map(LevelableTooltip::new, LevelableTooltip::skills);

    public void addTooltips(List<Component> toolTips, Item.TooltipContext context, TooltipFlag flag, int startingIndex) {
        if (!flag.hasShiftDown()) {
            toolTips.add(startingIndex++, (Component)Component.literal((String)"<Hold Shift For Skills>"));
        } else {
            toolTips.add(startingIndex++, (Component)Component.literal((String)"\u00a76Skills:"));
            for (Map.Entry<String, Float> entry : this.skills().entrySet()) {
                toolTips.add(startingIndex++, (Component)Component.literal((String)String.format("\u00a76     %s: %s", StringUtils.formatKey(entry.getKey()), StringUtils.formatFloat(entry.getValue().floatValue()))));
            }
        }
    }
}

