/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.armor;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.levelable.armor.CrystalToolsArmorMaterials;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.Equippable;

public class CrystalElytra
extends LevelableTool
implements LevelableItem {
    public CrystalElytra(Item.Properties properties) {
        super(properties.fireResistant().durability(CRYSTAL.durability()).component(net.minecraft.core.component.DataComponents.GLIDER, (Object)Unit.INSTANCE).component(net.minecraft.core.component.DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(SoundEvents.ARMOR_EQUIP_ELYTRA).setAsset(CrystalToolsArmorMaterials.CRYSTAL_ELYTRA).build()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> components, TooltipFlag flag) {
        String modeSwitchKey = RegisterKeyBindingsEvent.MODE_SWITCH.getKey().getDisplayName().getString();
        if (((Boolean)stack.getOrDefault(DataComponents.CREATIVE_FLIGHT, (Object)false)).booleanValue()) {
            if (((Boolean)stack.getOrDefault(DataComponents.DISABLE_CREATIVE_FLIGHT, (Object)false)).booleanValue()) {
                components.accept((Component)Component.literal((String)("\u00a7c\u00a7lCreative Flight Disabled (Ctrl + " + modeSwitchKey + ") To Enable")));
            } else {
                components.accept((Component)Component.literal((String)("\u00a79Ctrl + " + modeSwitchKey + " To Disable Creative Flight")));
            }
        }
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @Override
    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        Levelable levelable;
        LivingEntity livingEntity;
        super.inventoryTick(stack, level, entity, slot);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying() && livingEntity.getFallFlyingTicks() % 20 == 0 && (levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) != null) {
            levelable.addExp(entity.level(), entity.getOnPos(), livingEntity);
        }
    }
}

