/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block;

import com.mojang.serialization.MapCodec;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrystalPedestalBlock
extends BaseEntityBlock {
    public static final MapCodec<CrystalPedestalBlock> CODEC = CrystalPedestalBlock.simpleCodec(CrystalPedestalBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)14.0), Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), Block.box((double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0, (double)10.0), Block.box((double)4.0, (double)4.0, (double)8.0, (double)6.0, (double)6.0, (double)9.0), Block.box((double)4.0, (double)10.0, (double)8.0, (double)6.0, (double)12.0, (double)9.0), Block.box((double)10.0, (double)4.0, (double)8.0, (double)12.0, (double)6.0, (double)9.0), Block.box((double)10.0, (double)10.0, (double)8.0, (double)12.0, (double)12.0, (double)9.0)});
    private final Map<Direction, VoxelShape> shapes = Shapes.rotateAll((VoxelShape)SHAPE);

    public CrystalPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (level.isClientSide()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof CrystalPedestalBlockEntity) {
                    CrystalPedestalBlockEntity blockEntity = (CrystalPedestalBlockEntity)t;
                    blockEntity.clientTick(lvl, pos, blockState);
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof CrystalPedestalBlockEntity) {
                CrystalPedestalBlockEntity blockEntity = (CrystalPedestalBlockEntity)t;
                blockEntity.serverTick(level, blockEntity.getBlockPos(), blockState);
            }
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CrystalPedestalBlockEntity(pos, state);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystalPedestalBlockEntity) {
            CrystalPedestalBlockEntity crystalPedestalBlockEntity = (CrystalPedestalBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                this.openContainer(level, pos, player);
                return InteractionResult.CONSUME;
            }
            ItemStack result = crystalPedestalBlockEntity.setStack(stack);
            player.setItemInHand(hand, result);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    protected void openContainer(Level level, BlockPos pos, Player player) {
        CrystalPedestalBlockEntity crystalPedestalBlockEntity;
        block3: {
            block2: {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof CrystalPedestalBlockEntity)) break block2;
                crystalPedestalBlockEntity = (CrystalPedestalBlockEntity)blockEntity;
                if (player instanceof ServerPlayer) break block3;
            }
            throw new IllegalStateException("Crystal pedestal block doesn't have a block entity!");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.openMenu((MenuProvider)crystalPedestalBlockEntity, registryFriendlyByteBuf -> registryFriendlyByteBuf.writeBlockPos(pos));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.get(state.getValue(FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)blockPlaceContext.getClickedFace());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

