/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ActionBlockEntity
extends BlockEntity {
    private static final Codec<Map<ActionType, ActionParameters>> SAVED_ACTIONS_CODEC = Codec.unboundedMap(ActionType.CODEC, ActionParameters.CODEC);
    private final Map<ActionType, Action> actions = new HashMap<ActionType, Action>();
    private final Map<ActionType, ActionParameters> savedActions = new HashMap<ActionType, ActionParameters>();

    public ActionBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getDefaultActions().forEach(action -> this.actions.put(action.getActionType(), (Action)action));
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        for (Action action : this.getActions()) {
            action.onRemove();
        }
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.getActions().forEach(action -> action.load(valueInput));
        this.savedActions.putAll(valueInput.read("savedActions", SAVED_ACTIONS_CODEC).orElse(Map.of()));
        this.savedActions.forEach((type, parameters) -> {
            Action action = type.getActionInstance(this, (ActionParameters)parameters);
            if (action != null) {
                this.actions.put((ActionType)((Object)type), action);
            } else {
                CrystalTools.LOGGER.warn("Saved action parameters created null action {} {}", (Object)type, parameters);
            }
        });
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        for (Action action : this.getActions()) {
            action.applyComponents(componentGetter);
        }
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.getActions().forEach(action -> action.save(valueOutput));
        valueOutput.store("savedActions", SAVED_ACTIONS_CODEC, this.savedActions);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        for (Action action : this.getActions()) {
            action.collectComponents(components);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        for (Action action : this.getActions()) {
            action.tick(level, pos, state);
        }
    }

    protected <T extends Action> void addAction(T action, ActionParameters parameters) {
        this.actions.put(action.getActionType(), action);
        this.savedActions.put(action.getActionType(), parameters);
        this.setChanged();
    }

    protected void removeAction(ActionType actionType) {
        if (this.actions.containsKey((Object)actionType)) {
            this.actions.get((Object)actionType).onRemove();
            this.actions.remove((Object)actionType);
            this.savedActions.remove((Object)actionType);
            this.setChanged();
        }
    }

    protected boolean hasAction(ActionType actionType) {
        return this.actions.containsKey((Object)actionType);
    }

    protected Action getAction(ActionType actionType) {
        return this.actions.get((Object)actionType);
    }

    protected Iterable<Action> getActions() {
        return this.actions.values();
    }

    protected Collection<Action> getDefaultActions() {
        return List.of();
    }
}

