/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity;

import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.components.FurnaceData;
import dev.willyelton.crystal_tools.common.components.FurnaceUpgrades;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalFurnaceContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalFurnaceBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputable;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.LevelableContainerData;
import dev.willyelton.crystal_tools.utils.ArrayUtils;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import dev.willyelton.crystal_tools.utils.NBTUtils;
import dev.willyelton.crystal_tools.utils.constants.BlockEntityResourceLocations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class CrystalFurnaceBlockEntity
extends LevelableBlockEntity
implements WorldlyContainer,
MenuProvider,
AutoOutputable {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4};
    public static final int[] OUTPUT_SLOTS = new int[]{5, 6, 7, 8, 9};
    public static final int[] FUEL_SLOTS = new int[]{10, 11, 12};
    public static final int MAX_SLOTS = 5;
    public static final int MAX_FUEL_SLOTS = 3;
    public static final int SIZE = 13;
    public static final int DATA_SIZE = 14;
    public static final List<String> NBT_TAGS = new ArrayList<String>(List.of("SpeedUpgrade", "FuelEfficiencyUpgrade", "Slots", "FuelSlots", "Balance", "AutoOutput", "ExpModifier", "Items"));
    private final int fuelEfficiencyAddedTicks;
    private final int speedUpgradeSubtractTicks;
    private final double expBoostPercentage;
    private NonNullList<ItemStack> items;
    private final Map<Direction, IItemHandler> sidedCaps;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.SMELTING;
    private int litTime = 0;
    private int litTotalTime = 0;
    private int[] cookingProgress = new int[5];
    private int[] cookingTotalTime = new int[5];
    private float expHeld = 0.0f;
    private float speedUpgrade = 0.0f;
    private int fuelEfficiencyUpgrade = 0;
    private int bonusSlots = 0;
    private int bonusFuelSlots = 0;
    private boolean balance = false;
    private float expModifier;
    private boolean saveFuel = false;
    private AutoOutputAction autoOutputAction;
    protected final ContainerData dataAccess = new LevelableContainerData(this){

        @Override
        protected int getExtra(int index) {
            return switch (index) {
                case 3 -> CrystalFurnaceBlockEntity.this.litTime;
                case 4 -> CrystalFurnaceBlockEntity.this.litTotalTime;
                case 5 -> CrystalFurnaceBlockEntity.this.bonusSlots;
                case 6 -> CrystalFurnaceBlockEntity.this.bonusFuelSlots;
                case 7 -> CrystalFurnaceBlockEntity.this.cookingProgress[0];
                case 8 -> CrystalFurnaceBlockEntity.this.cookingProgress[1];
                case 9 -> CrystalFurnaceBlockEntity.this.cookingProgress[2];
                case 10 -> CrystalFurnaceBlockEntity.this.cookingProgress[3];
                case 11 -> CrystalFurnaceBlockEntity.this.cookingProgress[4];
                case 12 -> CrystalFurnaceBlockEntity.this.cookingTotalTime[0];
                case 13 -> CrystalFurnaceBlockEntity.this.cookingTotalTime[1];
                case 14 -> CrystalFurnaceBlockEntity.this.cookingTotalTime[2];
                case 15 -> CrystalFurnaceBlockEntity.this.cookingTotalTime[3];
                case 16 -> CrystalFurnaceBlockEntity.this.cookingTotalTime[4];
                default -> 0;
            };
        }

        @Override
        protected void setExtra(int index, int value) {
            switch (index) {
                case 3: {
                    CrystalFurnaceBlockEntity.this.litTime = value;
                    break;
                }
                case 4: {
                    CrystalFurnaceBlockEntity.this.litTotalTime = value;
                    break;
                }
                case 5: {
                    CrystalFurnaceBlockEntity.this.bonusSlots = Math.min(value, 5);
                    break;
                }
                case 6: {
                    CrystalFurnaceBlockEntity.this.bonusFuelSlots = Math.min(value, 3);
                    break;
                }
                case 7: {
                    CrystalFurnaceBlockEntity.this.cookingProgress[0] = value;
                    break;
                }
                case 8: {
                    CrystalFurnaceBlockEntity.this.cookingProgress[1] = value;
                    break;
                }
                case 9: {
                    CrystalFurnaceBlockEntity.this.cookingProgress[2] = value;
                    break;
                }
                case 10: {
                    CrystalFurnaceBlockEntity.this.cookingProgress[3] = value;
                    break;
                }
                case 11: {
                    CrystalFurnaceBlockEntity.this.cookingProgress[4] = value;
                    break;
                }
                case 12: {
                    CrystalFurnaceBlockEntity.this.cookingTotalTime[0] = value;
                    break;
                }
                case 13: {
                    CrystalFurnaceBlockEntity.this.cookingTotalTime[1] = value;
                    break;
                }
                case 14: {
                    CrystalFurnaceBlockEntity.this.cookingTotalTime[2] = value;
                    break;
                }
                case 15: {
                    CrystalFurnaceBlockEntity.this.cookingTotalTime[3] = value;
                    break;
                }
                case 16: {
                    CrystalFurnaceBlockEntity.this.cookingTotalTime[4] = value;
                }
            }
        }

        @Override
        protected int getExtraDataSize() {
            return 14;
        }
    };

    public CrystalFurnaceBlockEntity(BlockPos pPos, BlockState state) {
        super((BlockEntityType)Registration.CRYSTAL_FURNACE_BLOCK_ENTITY.get(), pPos, state);
        this.items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        this.fuelEfficiencyAddedTicks = (Integer)CrystalToolsConfig.FUEL_EFFICIENCY_ADDED_TICKS.get();
        this.speedUpgradeSubtractTicks = (Integer)CrystalToolsConfig.SPEED_UPGRADE_SUBTRACT_TICKS.get();
        this.expBoostPercentage = (Double)CrystalToolsConfig.EXPERIENCE_BOOST_PERCENTAGE.get();
        this.sidedCaps = Arrays.stream(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}).map(direction -> Map.entry(direction, new SidedInvWrapper((WorldlyContainer)this, direction))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    protected Collection<Action> getDefaultActions() {
        this.autoOutputAction = new AutoOutputAction((ActionBlockEntity)this, this);
        return List.of(this.autoOutputAction);
    }

    public IItemHandler getCapForSide(Direction side) {
        return this.sidedCaps.get(side);
    }

    public int[] getSlotsForFace(Direction face) {
        switch (face) {
            case DOWN: {
                return OUTPUT_SLOTS;
            }
            case UP: {
                return INPUT_SLOTS;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                return FUEL_SLOTS;
            }
        }
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, Direction pDirection) {
        return this.canPlaceItem(pIndex, pItemStack);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (ArrayUtils.arrayContains(INPUT_SLOTS, index)) {
            return index <= INPUT_SLOTS[this.bonusSlots];
        }
        if (ArrayUtils.arrayContains(OUTPUT_SLOTS, index)) {
            return false;
        }
        if (ArrayUtils.arrayContains(FUEL_SLOTS, index)) {
            return index <= FUEL_SLOTS[this.bonusFuelSlots] && stack.getBurnTime(RecipeType.SMELTING, this.level.fuelValues()) > 0;
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection != Direction.DOWN || pIndex != 1;
    }

    public int getContainerSize() {
        return 13;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    @Override
    public Map<Integer, ItemStack> getOutputStacks() {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (int i : OUTPUT_SLOTS) {
            items.put(i, (ItemStack)this.items.get(i));
        }
        return items;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        ItemStack current = (ItemStack)this.items.get(slot);
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (ArrayUtils.arrayContains(INPUT_SLOTS, slot) && (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)current))) {
            int index = ArrayUtils.indexOf(INPUT_SLOTS, slot);
            RecipeHolder<AbstractCookingRecipe> recipe = this.getRecipe(stack);
            if (recipe != null) {
                this.cookingTotalTime[index] = this.getTotalCookTime(recipe, index);
                this.cookingProgress[index] = 0;
                this.setChanged();
            }
        }
        if (ArrayUtils.arrayContains(FUEL_SLOTS, slot) && this.getRecipe(stack) != null) {
            this.balanceFuel();
        }
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.crystal_tools.crystal_furnace");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new CrystalFurnaceContainerMenu(containerId, player.level(), this.getBlockPos(), playerInventory, this.dataAccess);
    }

    @Override
    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        this.litTime = valueInput.getInt("LitTime").orElse(0);
        this.litTotalTime = valueInput.getInt("LitDuration").orElse(0);
        this.cookingProgress = NBTUtils.getIntArray(valueInput, "CookingProgress", 5);
        this.cookingTotalTime = NBTUtils.getIntArray(valueInput, "CookingTotalTime", 5);
        this.expHeld = valueInput.getFloatOr("ExpHeld", 0.0f);
        this.speedUpgrade = valueInput.getFloatOr("SpeedUpgrade", 0.0f);
        this.fuelEfficiencyUpgrade = valueInput.getInt("FuelEfficiencyUpgrade").orElse(0);
        this.bonusSlots = Math.min(valueInput.getInt("Slots").orElse(0), 5);
        this.bonusFuelSlots = Math.min(valueInput.getInt("FuelSlots").orElse(0), 3);
        this.balance = valueInput.getBooleanOr("Balance", false);
        this.expModifier = valueInput.getFloatOr("ExpModifier", 0.0f);
        this.saveFuel = valueInput.getBooleanOr("SaveFuel", false);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        FurnaceUpgrades furnaceUpgrades;
        FurnaceData furnaceData;
        super.applyImplicitComponents(componentInput);
        ItemContainerContents contents = (ItemContainerContents)componentInput.get(net.minecraft.core.component.DataComponents.CONTAINER);
        this.items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        if (contents != null) {
            contents.copyInto(this.items);
        }
        if ((furnaceData = (FurnaceData)componentInput.get(DataComponents.FURNACE_DATA)) != null) {
            this.litTime = furnaceData.litTime();
            this.litTotalTime = furnaceData.litDuration();
            this.cookingProgress = furnaceData.cookingProgress().stream().mapToInt(Integer::intValue).toArray();
            this.cookingTotalTime = furnaceData.cookingTime().stream().mapToInt(Integer::intValue).toArray();
            this.expHeld = furnaceData.expHeld();
        }
        if ((furnaceUpgrades = (FurnaceUpgrades)componentInput.get(DataComponents.FURNACE_UPGRADES)) != null) {
            this.speedUpgrade = furnaceUpgrades.speed();
            this.fuelEfficiencyUpgrade = furnaceUpgrades.fuelEfficiency();
            this.bonusSlots = Math.min(furnaceUpgrades.slots(), 5);
            this.bonusFuelSlots = Math.min(furnaceUpgrades.fuelSlots(), 3);
            this.balance = furnaceUpgrades.balance();
            this.expModifier = furnaceUpgrades.expModifier();
            this.saveFuel = furnaceUpgrades.saveFuel();
        }
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
        valueOutput.putInt("LitTime", this.litTime);
        valueOutput.putInt("LitDuration", this.litTotalTime);
        valueOutput.putIntArray("CookingProgress", this.cookingProgress);
        valueOutput.putIntArray("CookingTotalTime", this.cookingTotalTime);
        valueOutput.putFloat("ExpHeld", this.expHeld);
        valueOutput.putFloat("SpeedUpgrade", this.speedUpgrade);
        valueOutput.putInt("FuelEfficiencyUpgrade", this.fuelEfficiencyUpgrade);
        valueOutput.putInt("Slots", this.bonusSlots);
        valueOutput.putInt("FuelSlots", this.bonusFuelSlots);
        valueOutput.putBoolean("Balance", this.balance);
        valueOutput.putFloat("ExpModifier", this.expModifier);
        valueOutput.putBoolean("SaveFuel", this.saveFuel);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        FurnaceData furnaceData = new FurnaceData(this.litTime, this.litTotalTime, Arrays.stream(this.cookingProgress).boxed().toList(), Arrays.stream(this.cookingTotalTime).boxed().toList(), this.expHeld);
        components.set(DataComponents.FURNACE_DATA, (Object)furnaceData);
        FurnaceUpgrades furnaceUpgrades = new FurnaceUpgrades(this.speedUpgrade, this.fuelEfficiencyUpgrade, this.bonusSlots, this.bonusFuelSlots, this.balance, this.expModifier, this.saveFuel);
        components.set(DataComponents.FURNACE_UPGRADES, (Object)furnaceUpgrades);
        ItemContainerContents contents = ItemContainerContents.fromItems(this.items);
        components.set(net.minecraft.core.component.DataComponents.CONTAINER, (Object)contents);
    }

    @Override
    protected void addToExtraData(String key, float value) {
        if (BlockEntityResourceLocations.FURNACE_SPEED.toString().equals(key)) {
            this.speedUpgrade += value;
        } else if (BlockEntityResourceLocations.FUEL_EFFICIENCY.toString().equals(key)) {
            this.fuelEfficiencyUpgrade += (int)value;
        } else if (BlockEntityResourceLocations.SLOT_BONUS.toString().equals(key)) {
            if (this.bonusSlots >= 4) {
                CrystalTools.LOGGER.warn("Furnace Max Slot Size Reached");
            } else {
                this.bonusSlots += (int)value;
            }
        } else if (BlockEntityResourceLocations.FUEL_SLOT_BONUS.toString().equals(key)) {
            if (this.bonusFuelSlots >= 2) {
                CrystalTools.LOGGER.warn("Furnace Max Fuel Slot Size Reached");
            } else {
                this.bonusFuelSlots += (int)value;
            }
        } else if (BlockEntityResourceLocations.AUTO_BALANCE.toString().equals(key)) {
            this.balance = value == 1.0f;
        } else if (BlockEntityResourceLocations.EXP_BOOST.toString().equals(key)) {
            this.expModifier += value;
        } else if (BlockEntityResourceLocations.SAVE_FUEL.toString().equals(key)) {
            this.saveFuel = value == 1.0f;
        }
    }

    @Override
    protected void resetExtraSkills() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Containers.dropContents((Level)serverLevel, (BlockPos)this.getBlockPos(), (Container)this);
            this.popExp(serverLevel, Vec3.atCenterOf((Vec3i)this.getBlockPos()));
            BlockState state = this.level.getBlockState(this.getBlockPos());
            state = (BlockState)state.setValue((Property)CrystalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(false));
            this.level.setBlock(this.getBlockPos(), state, 3);
        }
        this.items = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        this.litTime = 0;
        this.litTotalTime = 0;
        this.cookingProgress = new int[5];
        this.cookingTotalTime = new int[5];
        this.expHeld = 0.0f;
        this.speedUpgrade = 0.0f;
        this.fuelEfficiencyUpgrade = 0;
        this.bonusSlots = 0;
        this.bonusFuelSlots = 0;
        this.balance = false;
        this.expModifier = 0.0f;
        this.saveFuel = false;
    }

    public boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(this.recipeType, this.level.fuelValues()) > 0;
    }

    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    public int[] getOutputSLots() {
        return OUTPUT_SLOTS;
    }

    public int[] getFuelSlots() {
        return FUEL_SLOTS;
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.getRecipe(stack) != null;
    }

    protected RecipeHolder<AbstractCookingRecipe> getRecipe(ItemStack item) {
        if (this.level != null && this.level.isClientSide) {
            return null;
        }
        Optional recipeHolderOptional = item.getItem() instanceof AirItem ? Optional.empty() : ((ServerLevel)this.level).recipeAccess().getRecipeFor(this.recipeType, (RecipeInput)new SingleRecipeInput(item), this.level);
        return recipeHolderOptional.orElse(null);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ItemStack fuelItemStack;
        boolean isLit = this.isLit();
        boolean needsRebalance = false;
        boolean needChange = false;
        if (isLit) {
            if (!this.saveFuel || this.hasInputItems() && this.saveFuel) {
                --this.litTime;
            }
            super.serverTick(level, pos, state);
        }
        boolean hasFuel = !(fuelItemStack = (ItemStack)this.items.get(FUEL_SLOTS[0])).isEmpty();
        for (int slotIndex = 0; slotIndex < this.bonusSlots + 1; ++slotIndex) {
            boolean hasItemToSmelt;
            int slot = INPUT_SLOTS[slotIndex];
            boolean bl = hasItemToSmelt = !((ItemStack)this.items.get(slot)).isEmpty();
            if (this.isLit() || hasFuel && hasItemToSmelt) {
                RecipeHolder<AbstractCookingRecipe> recipe = this.getRecipe(this.getItem(slot));
                if (!this.isLit() && this.canBurn(level.registryAccess(), recipe, slot)) {
                    this.litTotalTime = this.litTime = this.getBurnDuration(fuelItemStack);
                    if (this.isLit()) {
                        needChange = true;
                        if (!fuelItemStack.getCraftingRemainder().isEmpty()) {
                            this.items.set(FUEL_SLOTS[0], (Object)fuelItemStack.getCraftingRemainder());
                        } else {
                            fuelItemStack.shrink(1);
                            if (fuelItemStack.isEmpty()) {
                                this.items.set(FUEL_SLOTS[0], (Object)fuelItemStack.getCraftingRemainder());
                            }
                        }
                        this.balanceFuel();
                    }
                }
                if (this.isLit() && this.canBurn(level.registryAccess(), recipe, slot)) {
                    int n = slotIndex;
                    this.cookingProgress[n] = this.cookingProgress[n] + 1;
                    if (this.cookingProgress[slotIndex] != this.cookingTotalTime[slotIndex]) continue;
                    this.cookingProgress[slotIndex] = 0;
                    this.cookingTotalTime[slotIndex] = this.getTotalCookTime(recipe, slot);
                    if (this.burn(level.registryAccess(), recipe, slot)) {
                        needsRebalance = true;
                    }
                    needChange = true;
                    continue;
                }
                this.cookingProgress[slotIndex] = 0;
                continue;
            }
            if (this.cookingProgress[slotIndex] <= 0) continue;
            this.cookingProgress[slotIndex] = Mth.clamp((int)(this.cookingProgress[slotIndex] - 2), (int)0, (int)this.cookingTotalTime[slotIndex]);
        }
        if (isLit != this.isLit()) {
            needChange = true;
            state = (BlockState)state.setValue((Property)CrystalFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            level.setBlock(pos, state, 3);
        }
        if (needsRebalance) {
            this.balanceInputs();
            this.autoOutputAction.tickAction(level, pos, state);
        }
        if (needChange) {
            CrystalFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.popExp(serverlevel, Vec3.atCenterOf((Vec3i)pos));
        }
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private boolean canBurn(RegistryAccess registryAccess, RecipeHolder<?> recipe, int slot) {
        ItemStack recipeOutput;
        int outputSlot = slot + 5;
        if (!this.getItem(slot).isEmpty() && recipe != null && !(recipeOutput = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(this.getItem(slot)), (HolderLookup.Provider)registryAccess)).isEmpty()) {
            ItemStack output = this.getItem(outputSlot);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(RegistryAccess registryAccess, RecipeHolder<?> recipe, int slot) {
        if (recipe != null && this.canBurn(registryAccess, recipe, slot)) {
            AbstractCookingRecipe castedRecipe = (AbstractCookingRecipe)recipe.value();
            ItemStack input = (ItemStack)this.items.get(slot);
            ItemStack output = (ItemStack)this.items.get(slot + 5);
            ItemStack recipeOutput = castedRecipe.assemble(new SingleRecipeInput(this.getItem(slot)), (HolderLookup.Provider)registryAccess);
            if (output.isEmpty()) {
                this.items.set(slot + 5, (Object)recipeOutput.copy());
            } else if (output.is(recipeOutput.getItem())) {
                output.grow(recipeOutput.getCount());
            }
            if (input.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)this.items.get(slot)).isEmpty() && ((ItemStack)this.items.get(slot)).is(Items.BUCKET)) {
                this.items.set(slot + 5, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            input.shrink(1);
            this.expHeld += castedRecipe.experience();
            int skillExp = (int)Math.ceil((double)(castedRecipe.experience() * 10.0f) * (Double)CrystalToolsConfig.FURNACE_EXPERIENCE_BOOST.get());
            this.addExp(skillExp);
            return true;
        }
        return false;
    }

    private int getBurnDuration(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return stack.getBurnTime(this.recipeType, this.level.fuelValues()) + this.fuelEfficiencyUpgrade * this.fuelEfficiencyAddedTicks;
    }

    private int getTotalCookTime(RecipeHolder<AbstractCookingRecipe> recipe, int slot) {
        if (!this.getItem(slot).isEmpty() && recipe != null) {
            return Math.max(((AbstractCookingRecipe)recipe.value()).cookingTime() - (int)(this.speedUpgrade * (float)this.speedUpgradeSubtractTicks), 1);
        }
        return 0;
    }

    public void popExp(ServerPlayer player) {
        this.popExp(player.level(), player.position());
    }

    public void popExp(ServerLevel level, Vec3 pos) {
        int expAmount = (int)Math.ceil((double)this.expHeld * (1.0 + (double)this.expModifier * this.expBoostPercentage));
        ExperienceOrb.award((ServerLevel)level, (Vec3)pos, (int)expAmount);
        this.expHeld = 0.0f;
    }

    private void balanceFuel() {
        ItemStack fuel1 = (ItemStack)this.items.get(FUEL_SLOTS[0]);
        ItemStack fuel2 = (ItemStack)this.items.get(FUEL_SLOTS[1]);
        ItemStack fuel3 = (ItemStack)this.items.get(FUEL_SLOTS[2]);
        this.combineStacks(fuel1, fuel2);
        this.combineStacks(fuel1, fuel3);
        this.combineStacks(fuel2, fuel3);
    }

    private void combineStacks(ItemStack stackInto, ItemStack stackFrom) {
        if (ItemStackUtils.sameItem(stackInto, stackFrom) && stackInto.getCount() < stackInto.getMaxStackSize()) {
            int totalCount = stackInto.getCount() + stackFrom.getCount();
            if (totalCount < stackInto.getMaxStackSize()) {
                stackInto.setCount(totalCount);
                stackFrom.setCount(0);
            } else {
                stackInto.setCount(stackInto.getMaxStackSize());
                stackFrom.setCount(totalCount - stackInto.getMaxStackSize());
            }
        }
    }

    private void balanceInputs() {
        if (this.balance) {
            int[] activeInputSlots = Arrays.copyOfRange(INPUT_SLOTS, 0, this.bonusSlots + 1);
            Item[] items = new Item[activeInputSlots.length];
            HashMap<Item, Integer> itemMap = new HashMap<Item, Integer>();
            for (int i = 0; i < activeInputSlots.length; ++i) {
                ItemStack stack = this.getItem(activeInputSlots[i]);
                items[i] = stack.getItem();
                if (stack.is(Items.AIR)) continue;
                if (itemMap.containsKey(stack.getItem())) {
                    itemMap.put(stack.getItem(), (Integer)itemMap.get(stack.getItem()) + stack.getCount());
                    continue;
                }
                itemMap.put(stack.getItem(), stack.getCount());
            }
            for (Item item : itemMap.keySet()) {
                int[] indices = ArrayUtils.indicesOf(items, item);
                int[] emptyIndices = ArrayUtils.indicesOf(items, Items.AIR);
                int[] allIndices = ArrayUtils.combineArrays(indices, emptyIndices);
                int slots = allIndices.length;
                int totalCount = (Integer)itemMap.get(item);
                int stackCount = totalCount / slots;
                int leftOver = totalCount % slots;
                for (int index : allIndices) {
                    int bonus = leftOver-- > 0 ? 1 : 0;
                    ItemStack toSet = new ItemStack((ItemLike)item, stackCount + bonus);
                    this.setItem(activeInputSlots[index], toSet);
                    items[index] = item;
                }
            }
        }
    }

    private boolean hasInputItems() {
        for (int i : INPUT_SLOTS) {
            if (((ItemStack)this.items.get(i)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    static {
        NBT_TAGS.addAll(LevelableBlockEntity.NBT_TAGS);
    }
}

