/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.block.entity.action;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.common.levelable.block.entity.ActionBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.Action;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ActionParameters;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.AutoOutputable;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.BlockBreakAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ChunkLoader;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.ChunkLoadingAction;
import dev.willyelton.crystal_tools.common.levelable.block.entity.action.MagnetAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum ActionType implements StringRepresentable
{
    AUTO_OUTPUT(AutoOutputAction.class, AutoOutputable.class, "crystal_tools.action.auto_output"),
    CHUNK_LOAD(ChunkLoadingAction.class, ChunkLoader.class, "crystal_tools.action.chunk_load"),
    MAGNET(MagnetAction.class, null, "crystal_tools.action.magnet"),
    BLOCK_BREAK(BlockBreakAction.class, null, "crystal_tools.action.block_break");

    public static final Codec<ActionType> CODEC;
    private final Class<? extends Action> actionClass;
    private final Class<?> contextClass;
    private final String description;

    private ActionType(Class<? extends Action> actionClass, Class<?> contextClass, String description) {
        this.actionClass = actionClass;
        this.contextClass = contextClass;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Action getActionInstance(ActionBlockEntity blockEntity, @Nullable ActionParameters actionParameters) {
        if (this.contextClass == null) {
            Constructor<? extends Action> constructor = this.getConstructor(ActionBlockEntity.class, ActionParameters.class);
            if (constructor != null) {
                return this.getActionFromConstructor(constructor, new Object[]{blockEntity, actionParameters});
            }
            CrystalTools.LOGGER.error("Failed to instantiate action class {}, no matching constructor found", this.actionClass);
            return null;
        }
        if (!this.contextClass.isAssignableFrom(((Object)((Object)blockEntity)).getClass())) {
            CrystalTools.LOGGER.error("Action type {} expects the ActionBlockEntity to implement {}", (Object)this, (Object)this.contextClass.getName());
            return null;
        }
        Constructor<? extends Action> constructor = this.getConstructor(ActionBlockEntity.class, ActionParameters.class, this.contextClass);
        if (constructor != null) {
            return this.getActionFromConstructor(constructor, new Object[]{blockEntity, actionParameters, blockEntity});
        }
        CrystalTools.LOGGER.error("Failed to instantiate action class {}, no matching constructor found", this.actionClass);
        return null;
    }

    @Nullable
    private Constructor<? extends Action> getConstructor(Class<?> ... parameters) {
        try {
            return this.actionClass.getConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private Action getActionFromConstructor(Constructor<? extends Action> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ActionType::values);
    }
}

