/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.AttributeNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.BlockEntityNbtNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.DataComponentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.EffectNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.EnchantmentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.FoodDataComponentNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeOrSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NotNodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillItemRequirement;
import dev.willyelton.crystal_tools.datagen.CrystalToolsItemSkillTrees;
import dev.willyelton.crystal_tools.utils.ListUtils;
import dev.willyelton.crystal_tools.utils.constants.SkillTreeDescriptions;
import dev.willyelton.crystal_tools.utils.constants.SkillTreeTitles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class SkillData {
    public static final Codec<SkillData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkillDataNode.CODEC.listOf().listOf().fieldOf("tiers").forGetter(SkillData::getAllNodesByTier), (App)EquipmentSlot.CODEC.optionalFieldOf("equipmentSlot").forGetter(s -> Optional.ofNullable(s.getEquipmentSlot()))).apply((Applicative)instance, SkillData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkillData> STREAM_CODEC = StreamCodec.composite((StreamCodec)SkillDataNode.STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list()), SkillData::getAllNodesByTier, (StreamCodec)ByteBufCodecs.optional((StreamCodec)EquipmentSlot.STREAM_CODEC), s -> Optional.ofNullable(s.getEquipmentSlot()), SkillData::new);
    private final EquipmentSlot equipmentSlot;
    private final List<List<SkillDataNode>> nodes;
    private List<SkillDataNode> flatNodes = null;
    private Map<Integer, SkillDataNode> nodeMap = null;

    private SkillData(List<List<SkillDataNode>> nodes, EquipmentSlot equipmentSlot) {
        this.nodes = nodes;
        this.equipmentSlot = equipmentSlot;
    }

    private SkillData(List<List<SkillDataNode>> nodes, Optional<EquipmentSlot> equipmentSlotOptional) {
        this(nodes, (EquipmentSlot)equipmentSlotOptional.orElse(null));
    }

    public List<List<SkillDataNode>> getAllNodesByTier() {
        return this.nodes;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    public List<SkillDataNode> getAllNodes() {
        if (this.flatNodes == null) {
            this.flatNodes = ListUtils.flattenList(this.nodes);
        }
        return this.flatNodes;
    }

    public Map<Integer, SkillDataNode> getNodeMap() {
        if (this.nodeMap == null) {
            this.nodeMap = this.nodes.stream().flatMap(Collection::stream).collect(Collectors.toMap(SkillDataNode::getId, Function.identity()));
        }
        return this.nodeMap;
    }

    public static Builder builder(EquipmentSlot slot) {
        return new Builder(slot);
    }

    public static class Builder {
        private final List<List<SkillDataNode>> nodes = new ArrayList<List<SkillDataNode>>();
        private final EquipmentSlot equipmentSlot;
        private List<SkillDataNode> currentTier;
        private List<SkillDataNode> previousTier;
        private SkillDataNode currentNode = null;
        private boolean including = true;

        private Builder(EquipmentSlot slot) {
            this.equipmentSlot = slot;
        }

        public Builder tier() {
            this.previousTier = this.currentTier;
            this.currentTier = new ArrayList<SkillDataNode>();
            this.nodes.add(this.currentTier);
            this.currentNode = null;
            return this;
        }

        public Builder attributeNode(int id, String name, String description, ResourceLocation attribute, float value) {
            return this.attributeNode(id, name, description, List.of(attribute), value);
        }

        public Builder attributeNode(int id, String name, String description, List<ResourceLocation> attributes, float value) {
            return this.attributeNode(id, name, description, attributes, value, 1, false);
        }

        public Builder attributeNode(int id, String name, String description, ResourceLocation attribute, float value, int limit, boolean threshold) {
            return this.attributeNode(id, name, description, List.of(attribute), value, limit, threshold);
        }

        public Builder attributeNode(int id, String name, String description, List<ResourceLocation> attributes, float value, int limit, boolean threshold) {
            if (this.including) {
                this.currentNode = new AttributeNode(id, name, description, limit, attributes, value, new ArrayList<SkillDataRequirement>(), Optional.empty(), threshold);
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder infiniteAttributeNode(int id, String name, String description, ResourceLocation attribute, float value) {
            return this.infiniteAttributeNode(id, name, description, List.of(attribute), value);
        }

        public Builder infiniteAttributeNode(int id, String name, String description, List<ResourceLocation> attributes, float value) {
            return this.attributeNode(id, name, description, attributes, value, 0, false);
        }

        public Builder dataComponentNode(int id, String name, String description, ResourceLocation dataComponent, float value) {
            return this.dataComponentNode(id, name, description, dataComponent, value, 1);
        }

        public Builder dataComponentNode(int id, String name, String description, ResourceLocation dataComponent, float value, int limit) {
            if (this.including) {
                this.currentNode = new DataComponentNode(id, name, description, limit, dataComponent, value, new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder infiniteDataComponentNode(int id, String name, String description, ResourceLocation dataComponent, float value) {
            return this.dataComponentNode(id, name, description, dataComponent, value, 0);
        }

        public Builder enchantmentNode(int id, String name, String description, ResourceKey<Enchantment> enchantment, int level) {
            if (this.including) {
                this.currentNode = new EnchantmentNode(id, name, description, enchantment.location(), level, new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder enchantmentNode(int id, SkillTreeDescriptions desc, ResourceKey<Enchantment> enchantment, int level) {
            String name = CrystalToolsItemSkillTrees.enchantmentName(enchantment, level);
            return this.enchantmentNode(id, name, desc.enchantment(name), enchantment, level == 0 ? 1 : level);
        }

        public Builder nutrition(int id, int level, int nutrition, String description) {
            return this.nutrition(id, level, nutrition, description, 1);
        }

        public Builder nutrition(int id, int level, int nutrition, String description, int limit) {
            if (this.including) {
                this.currentNode = new FoodDataComponentNode(id, SkillTreeTitles.nutrition(level), description, limit, new FoodProperties(nutrition, 0.0f, false), new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder saturation(int id, int level, float saturation, String description) {
            return this.saturation(id, level, saturation, description, 1);
        }

        public Builder saturation(int id, int level, float saturation, String description, int limit) {
            if (this.including) {
                this.currentNode = new FoodDataComponentNode(id, SkillTreeTitles.saturation(level), description, limit, new FoodProperties(0, saturation, false), new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder alwaysEat(int id, String description) {
            if (this.including) {
                this.currentNode = new FoodDataComponentNode(id, "Always Edible", description, 1, new FoodProperties(0, 0.0f, true), new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder effect(int id, SkillTreeDescriptions description, MobEffectInstance effectInstance) {
            return this.effect(id, description, effectInstance, "");
        }

        public Builder effect(int id, SkillTreeDescriptions description, MobEffectInstance effectInstance, String prefix) {
            return this.effect(id, description, effectInstance, prefix, true);
        }

        public Builder effect(int id, SkillTreeDescriptions description, MobEffectInstance effectInstance, String prefix, boolean infinite) {
            if (this.including) {
                String effectName = prefix + ((MobEffect)effectInstance.getEffect().value()).getDisplayName().getString();
                this.currentNode = new EffectNode(id, effectName, description.effect(effectName, effectInstance.getDuration()), infinite ? 0 : 1, new ArrayList<SkillDataRequirement>(), Optional.empty(), effectInstance);
                if (infinite) {
                    this.currentNode.setSubtext(new SkillSubText("Increases duration for each level", "#ABABAB"));
                }
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder blockNode(int id, String name, String description, ResourceLocation key, float value) {
            return this.blockNode(id, name, description, key, value, 1);
        }

        public Builder blockNode(int id, String name, String description, ResourceLocation key, float value, int limit) {
            if (this.including) {
                this.currentNode = new BlockEntityNbtNode(id, name, description, limit, List.of(key), value, new ArrayList<SkillDataRequirement>(), Optional.empty());
                this.currentTier.add(this.currentNode);
            }
            return this;
        }

        public Builder energyCost() {
            return this.subText("Increases Energy Cost", "#FF0000");
        }

        public Builder subText(String subtext, String color) {
            if (this.including) {
                if (this.currentNode == null) {
                    throw new IllegalArgumentException("Cannot add subtext with no node!");
                }
                this.currentNode.setSubtext(new SkillSubText(subtext, color));
            }
            return this;
        }

        public Builder nodeRequirement(int ... nodes) {
            if (this.including) {
                if (this.currentNode == null) {
                    throw new IllegalArgumentException("Cannot add requirements with no node!");
                }
                this.currentNode.addRequirement(new NodeSkillDataRequirement(Arrays.stream(nodes).boxed().toList()));
            }
            return this;
        }

        public Builder previousTierOrRequirements() {
            if (this.including) {
                if (this.previousTier == null) {
                    throw new IllegalArgumentException("Cannot add previous tier or requirements with no previous tier!");
                }
                this.currentNode.addRequirement(new NodeOrSkillDataRequirement(this.previousTier.stream().filter(n -> !n.getDescription().equals(this.currentNode.getDescription())).map(SkillDataNode::getId).toList()));
            }
            return this;
        }

        public Builder previousTierAndRequirements(int ... otherNodes) {
            if (this.including) {
                if (this.previousTier == null) {
                    throw new IllegalArgumentException("Cannot add previous tier or requirements with no previous tier!");
                }
                List<Integer> prevNodes = this.previousTier.stream().filter(n -> !n.getDescription().equals(this.currentNode.getDescription())).map(SkillDataNode::getId).toList();
                ArrayList<Integer> finalNodes = new ArrayList<Integer>(prevNodes);
                finalNodes.addAll(Arrays.stream(otherNodes).boxed().toList());
                this.currentNode.addRequirement(new NodeSkillDataRequirement(finalNodes));
            }
            return this;
        }

        public Builder notNodeRequirement(int notNode, int unlessNode) {
            if (this.including) {
                this.currentNode.addRequirement(new NotNodeSkillDataRequirement(List.of(Integer.valueOf(notNode)), List.of(Integer.valueOf(unlessNode))));
            }
            return this;
        }

        public Builder itemRequirement(Item ... items) {
            if (this.including) {
                this.currentNode.addRequirement(new SkillItemRequirement(Arrays.stream(items).toList()));
            }
            return this;
        }

        public Builder optional(boolean include) {
            this.including = include;
            return this;
        }

        public Builder endOptional() {
            this.including = true;
            return this;
        }

        public SkillData build() {
            return new SkillData(this.nodes, this.equipmentSlot);
        }
    }
}

