/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class AttributeNode
extends SkillDataNode
implements ItemStackNode {
    public static final Codec<AttributeNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)ResourceLocation.CODEC.listOf().fieldOf("key").forGetter(SkillDataNode::getKeys), (App)Codec.FLOAT.fieldOf("value").forGetter(AttributeNode::getValue), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText())), (App)Codec.BOOL.optionalFieldOf("threshold", (Object)false).forGetter(AttributeNode::isThreshold)).apply((Applicative)instance, AttributeNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getLimit, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getKeys, (StreamCodec)ByteBufCodecs.FLOAT, AttributeNode::getValue, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), AttributeNode::new);
    public static final Map<Attribute, DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>>> TOGGLEABLE_ATTRIBUTES = Map.of((Attribute)NeoForgeMod.CREATIVE_FLIGHT.value(), DataComponents.CREATIVE_FLIGHT);
    private final float value;
    private final boolean threshold;

    public AttributeNode(int id, String name, String description, int limit, List<ResourceLocation> keys, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText, boolean threshold) {
        super(id, name, description, limit, keys, requirements, (SkillSubText)skillSubText.orElse(null));
        this.value = value;
        this.threshold = threshold;
        if (threshold) {
            this.setSubtext(new SkillSubText(String.format("Will activate after you put %s points in this node", this.getLimit()), "#ABABAB"));
        }
    }

    public AttributeNode(int id, String name, String description, int limit, List<ResourceLocation> keys, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        this(id, name, description, limit, keys, value, requirements, skillSubText, false);
    }

    public float getValue() {
        return this.value;
    }

    public boolean isThreshold() {
        return this.threshold;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.ATTRIBUTE;
    }

    @Override
    public void processNode(SkillData skillData, ItemStack stack, int pointsToSpend, RegistryAccess registryAccess) {
        int totalPoints;
        if (this.threshold && (totalPoints = ((SkillPoints)stack.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).getPoints(this.getId())) < this.getLimit()) {
            return;
        }
        if (skillData.getEquipmentSlot() == null) {
            return;
        }
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.getOrDefault(net.minecraft.core.component.DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        Registry attributeRegistry = registryAccess.lookupOrThrow(Registries.ATTRIBUTE);
        ItemAttributeModifiers newModifiers = modifiers;
        for (ResourceLocation key : this.getKeys()) {
            ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)key.getPath());
            Optional optionalAttribute = attributeRegistry.get(key);
            double bonusAmount = 0.0;
            if (!optionalAttribute.isPresent()) continue;
            Holder attributeHolder = (Holder)optionalAttribute.get();
            if (TOGGLEABLE_ATTRIBUTES.containsKey(attributeHolder.value())) {
                stack.set((Supplier)TOGGLEABLE_ATTRIBUTES.get(attributeHolder.value()), (Object)true);
            }
            for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
                if (!entry.modifier().id().equals((Object)rl)) continue;
                bonusAmount = entry.modifier().amount();
                break;
            }
            newModifiers = newModifiers.withModifierAdded(attributeHolder, new AttributeModifier(rl, bonusAmount + (double)(this.value * (float)pointsToSpend), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)skillData.getEquipmentSlot()));
        }
        stack.set(net.minecraft.core.component.DataComponents.ATTRIBUTE_MODIFIERS, (Object)newModifiers);
    }
}

