/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.BlockEntityNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class BlockEntityNbtNode
extends SkillDataNode
implements BlockEntityNode {
    public static final Codec<BlockEntityNbtNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)ResourceLocation.CODEC.listOf().fieldOf("key").forGetter(SkillDataNode::getKeys), (App)Codec.FLOAT.fieldOf("value").forGetter(BlockEntityNbtNode::getValue), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText()))).apply((Applicative)instance, BlockEntityNbtNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityNbtNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getLimit, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getKeys, (StreamCodec)ByteBufCodecs.FLOAT, BlockEntityNbtNode::getValue, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), BlockEntityNbtNode::new);
    private final float value;

    public BlockEntityNbtNode(int id, String name, String description, int limit, List<ResourceLocation> keys, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        super(id, name, description, limit, keys, requirements, (SkillSubText)skillSubText.orElse(null));
        this.value = value;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.BLOCK_ENTITY_NBT;
    }

    @Override
    public void processNode(SkillData skillData, LevelableBlockEntity blockEntity, int pointsToSpend, RegistryAccess registryAccess) {
        for (ResourceLocation key : this.getKeys()) {
            blockEntity.addToData(key.toString(), this.value * (float)pointsToSpend);
            blockEntity.addToPoints(this.getId(), pointsToSpend);
        }
    }

    public float getValue() {
        return this.value;
    }
}

