/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.node;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillNodeType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirements;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlocksAttacks;

public class DataComponentNode
extends SkillDataNode
implements ItemStackNode {
    public static final Codec<DataComponentNode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(SkillDataNode::getId), (App)Codec.STRING.fieldOf("name").forGetter(SkillDataNode::getName), (App)Codec.STRING.fieldOf("description").forGetter(SkillDataNode::getDescription), (App)Codec.INT.fieldOf("limit").forGetter(SkillDataNode::getLimit), (App)ResourceLocation.CODEC.listOf().fieldOf("key").forGetter(SkillDataNode::getKeys), (App)Codec.FLOAT.fieldOf("value").forGetter(DataComponentNode::getValue), (App)SkillDataRequirements.CODEC.listOf().fieldOf("requirements").forGetter(SkillDataNode::getRequirements), (App)SkillSubText.CODEC.optionalFieldOf("subtext").forGetter(n -> Optional.ofNullable(n.getSkillSubText()))).apply((Applicative)instance, DataComponentNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, SkillDataNode::getDescription, (StreamCodec)ByteBufCodecs.VAR_INT, SkillDataNode::getLimit, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getKeys, (StreamCodec)ByteBufCodecs.FLOAT, DataComponentNode::getValue, (StreamCodec)SkillDataRequirements.STREAM_CODEC.apply(ByteBufCodecs.list()), SkillDataNode::getRequirements, (StreamCodec)ByteBufCodecs.optional(SkillSubText.STREAM_CODEC), n -> Optional.ofNullable(n.getSkillSubText()), DataComponentNode::new);
    private final float value;

    public DataComponentNode(int id, String name, String description, int limit, List<ResourceLocation> keys, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        super(id, name, description, limit, keys, requirements, (SkillSubText)skillSubText.orElse(null));
        this.value = value;
    }

    public DataComponentNode(int id, String name, String description, int limit, ResourceLocation key, float value, List<SkillDataRequirement> requirements, Optional<SkillSubText> skillSubText) {
        this(id, name, description, limit, List.of(key), value, requirements, skillSubText);
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public SkillNodeType getSkillNodeType() {
        return SkillNodeType.DATA_COMPONENT;
    }

    @Override
    public void processNode(SkillData skillData, ItemStack stack, int pointsToSpend, RegistryAccess registryAccess) {
        Registry dataComponents = registryAccess.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
        for (ResourceLocation key : this.getKeys()) {
            Optional dataComponentOptional = dataComponents.get(key);
            if (!dataComponentOptional.isPresent()) continue;
            DataComponentType dataComponent = (DataComponentType)((Holder.Reference)dataComponentOptional.get()).value();
            Object value = stack.get(dataComponent);
            if (dataComponent.codec() == null) continue;
            if (Codec.BOOL.equals((Object)dataComponent.codec())) {
                stack.set(dataComponent, (Object)true);
                continue;
            }
            if (Codec.INT.equals((Object)dataComponent.codec()) || ExtraCodecs.POSITIVE_INT.equals((Object)dataComponent.codec()) || ExtraCodecs.NON_NEGATIVE_INT.equals((Object)dataComponent.codec())) {
                int intValue = value == null ? 0 : (Integer)value;
                stack.set(dataComponent, (Object)(intValue + (int)this.value * pointsToSpend));
                continue;
            }
            if (Codec.FLOAT.equals((Object)dataComponent.codec())) {
                float floatValue = value == null ? 0.0f : ((Float)value).floatValue();
                stack.set(dataComponent, (Object)Float.valueOf(floatValue + this.value * (float)pointsToSpend));
                continue;
            }
            if (DataComponents.BLOCKS_ATTACKS.equals((Object)dataComponent)) {
                if (value instanceof BlocksAttacks) {
                    BlocksAttacks oldBlocks = (BlocksAttacks)value;
                    BlocksAttacks newBlock = new BlocksAttacks(oldBlocks.blockDelaySeconds(), oldBlocks.disableCooldownScale() - this.value, oldBlocks.damageReductions(), oldBlocks.itemDamage(), oldBlocks.bypassedBy(), oldBlocks.blockSound(), oldBlocks.disableSound());
                    stack.set(DataComponents.BLOCKS_ATTACKS, (Object)newBlock);
                    continue;
                }
                CrystalTools.LOGGER.warn("Attempting to apply blocking data component to an Item without a BlocksAttacks data component");
                continue;
            }
            throw new IllegalStateException("Unexpected skill datacomponent type: " + String.valueOf(dataComponent));
        }
    }
}

