/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class NodeOrSkillDataRequirement
implements SkillDataRequirement,
SkillDataNodeRequirement {
    public static final MapCodec<NodeOrSkillDataRequirement> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.listOf().fieldOf("or_node").forGetter(NodeOrSkillDataRequirement::getRequiredNodes)).apply((Applicative)instance, NodeOrSkillDataRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NodeOrSkillDataRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), NodeOrSkillDataRequirement::getRequiredNodes, NodeOrSkillDataRequirement::new);
    private final List<Integer> nodes;

    public NodeOrSkillDataRequirement(List<Integer> nodes) {
        this.nodes = nodes;
    }

    @Override
    public boolean canLevel(SkillPoints points, Player player) {
        for (Integer requiredNode : this.nodes) {
            int pointsInNode = points.getPoints(requiredNode);
            if (pointsInNode <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getRequiredNodes() {
        return this.nodes;
    }

    @Override
    public RequirementType getRequirementType() {
        return RequirementType.NODE_OR;
    }

    @Override
    public MapCodec<? extends SkillDataRequirement> codec() {
        return MAP_CODEC;
    }
}

