/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;

public class NodeSkillDataRequirement
implements SkillDataRequirement,
SkillDataNodeRequirement {
    public static final MapCodec<NodeSkillDataRequirement> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.listOf().fieldOf("node").forGetter(NodeSkillDataRequirement::getRequiredNodes)).apply((Applicative)instance, NodeSkillDataRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NodeSkillDataRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), NodeSkillDataRequirement::getRequiredNodes, NodeSkillDataRequirement::new);
    private final List<Integer> requiredNodes;
    private final boolean inverse;
    protected final List<Integer> unless;

    public NodeSkillDataRequirement(List<Integer> requiredNodes) {
        this(requiredNodes, false);
    }

    protected NodeSkillDataRequirement(List<Integer> requiredNodes, boolean inverse) {
        this(requiredNodes, inverse, List.of());
    }

    protected NodeSkillDataRequirement(List<Integer> requiredNodes, boolean inverse, List<Integer> unless) {
        this.requiredNodes = requiredNodes;
        this.inverse = inverse;
        this.unless = unless;
    }

    @Override
    public boolean canLevel(SkillPoints points, Player player) {
        if (this.unlessActive(points)) {
            return true;
        }
        for (Integer node : this.requiredNodes) {
            int pointsInNode = points.getPoints(node);
            if ((this.inverse || pointsInNode != 0) && (!this.inverse || pointsInNode <= 0)) continue;
            return false;
        }
        return true;
    }

    private boolean unlessActive(SkillPoints points) {
        if (this.inverse) {
            for (Integer node : this.unless) {
                if (points.getPoints(node) != 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getRequiredNodes() {
        return this.requiredNodes;
    }

    protected List<Integer> getUnless() {
        return this.unless;
    }

    @Override
    public RequirementType getRequirementType() {
        return this.inverse ? RequirementType.NODE_NOT : RequirementType.NODE_AND;
    }

    @Override
    public MapCodec<? extends SkillDataRequirement> codec() {
        return MAP_CODEC;
    }
}

