/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.skill.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class SkillItemRequirement
implements SkillDataRequirement {
    public static final MapCodec<SkillItemRequirement> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().listOf().fieldOf("item").forGetter(SkillItemRequirement::getItems)).apply((Applicative)instance, SkillItemRequirement::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SkillItemRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.ITEM.key()).apply(ByteBufCodecs.list()), SkillItemRequirement::getItems, SkillItemRequirement::new);
    private final List<Item> items;

    public SkillItemRequirement(List<Item> items) {
        this.items = items;
    }

    @Override
    public boolean canLevel(SkillPoints points, Player player) {
        if (!((Boolean)CrystalToolsConfig.ENABLE_ITEM_REQUIREMENTS.get()).booleanValue()) {
            return true;
        }
        for (Item item : this.items) {
            if (this.hasItem(player, item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItem(Player player, Item item) {
        Inventory inventory = player.getInventory();
        return inventory.contains(item.getDefaultInstance());
    }

    @Override
    public RequirementType getRequirementType() {
        return RequirementType.ITEM;
    }

    @Override
    public MapCodec<? extends SkillDataRequirement> codec() {
        return MAP_CODEC;
    }

    public List<Item> getItems() {
        return this.items;
    }
}

