/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;

public class CrystalApple
extends LevelableTool {
    private static final int BASE_EAT_SPEED = 32;

    public CrystalApple(Item.Properties properties) {
        super(properties.durability(50).food(new FoodProperties(2, 0.4f, false)));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity player) {
        Levelable levelable;
        if (!(player instanceof Player) || !((Player)player).getAbilities().instabuild) {
            stack.grow(1);
        }
        if ((levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) != null) {
            FoodProperties food = (FoodProperties)stack.getOrDefault(net.minecraft.core.component.DataComponents.FOOD, (Object)new FoodProperties(0, 0.0f, false));
            int effectiveHunger = (int)((float)food.nutrition() * food.saturation() * 2.0f) + food.nutrition();
            levelable.addExp(level, player.getOnPos(), player, effectiveHunger);
            stack.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
        }
        return super.finishUsingItem(stack, level, player);
    }

    @Override
    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, EquipmentSlot slot) {
        this.levelableInventoryTick(itemStack, (Level)level, entity, slot, (Double)CrystalToolsConfig.APPLE_REPAIR_MODIFIER.get());
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32 - (Integer)stack.getOrDefault(DataComponents.EAT_SPEED_BONUS, (Object)0);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.EAT;
    }
}

