/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class CrystalFishingRod
extends LevelableTool {
    public static final String CRYSTAL_TOOLS_FISHING_MAIN_TAG = "crystal_tools.fishing.main";
    public static final String CRYSTAL_TOOLS_FISHING_OFF_TAG = "crystal_tools.fishing.off";

    public CrystalFishingRod(Item.Properties properties) {
        super(properties.durability(CRYSTAL.durability()));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int rodDamage = player.fishing.retrieve(stack);
                stack.hurtAndBreak(rodDamage, (ServerLevel)level, (LivingEntity)player, null);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, this.getRandomPitch(level));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, this.getRandomPitch(level));
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                int fishingSpeedBonus = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverlevel, (ItemStack)stack, (Entity)player) * 20.0f);
                int luckBonus = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverlevel, (ItemStack)stack, (Entity)player);
                FishingHook fishingHook = new FishingHook(player, level, fishingSpeedBonus, luckBonus);
                if (hand == InteractionHand.MAIN_HAND) {
                    fishingHook.addTag(CRYSTAL_TOOLS_FISHING_MAIN_TAG);
                } else if (hand == InteractionHand.OFF_HAND) {
                    fishingHook.addTag(CRYSTAL_TOOLS_FISHING_OFF_TAG);
                }
                level.addFreshEntity((Entity)fishingHook);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS.contains(itemAbility);
    }

    public boolean mineBlock(ItemStack tool, Level level, BlockState blockState, BlockPos blockPos, LivingEntity entity) {
        return false;
    }

    private float getRandomPitch(Level level) {
        return 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f);
    }

    public static void dropExtraItems(Collection<ItemStack> stacks, Player player, FishingHook hookEntity) {
        for (ItemStack itemstack : stacks) {
            ItemEntity itementity = new ItemEntity(player.level(), hookEntity.getX(), hookEntity.getY(), hookEntity.getZ(), itemstack);
            double d0 = player.getX() - hookEntity.getX();
            double d1 = player.getY() - hookEntity.getY();
            double d2 = player.getZ() - hookEntity.getZ();
            itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
            player.level().addFreshEntity((Entity)itementity);
            if (!itemstack.is(ItemTags.FISHES)) continue;
            player.awardStat(Stats.FISH_CAUGHT, 1);
        }
    }
}

