/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import dev.willyelton.crystal_tools.common.network.data.BlockBreakPayload;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.Nullable;

public abstract class LevelableTool
extends Item
implements LevelableItem {
    public LevelableTool(Item.Properties properties) {
        super(properties.fireResistant().rarity(Rarity.RARE).repairable(CrystalToolsTags.REPAIRS_CRYSTAL).stacksTo(1).component(net.minecraft.core.component.DataComponents.ENCHANTABLE, null));
    }

    public void hurtEnemy(ItemStack tool, LivingEntity target, LivingEntity attacker) {
        tool.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public void breakBlock(ItemStack stack, Level level, BlockPos blockPos, LivingEntity entity) {
        BlockState blockState = level.getBlockState(blockPos);
        if (this.isCorrectToolForDrops(stack, blockState) && !ToolUtils.isBroken(stack) && entity instanceof ServerPlayer) {
            Levelable levelable;
            if (!level.isClientSide) {
                Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)level.getBlockEntity(blockPos), (Entity)entity, (ItemStack)stack);
                level.destroyBlock(blockPos, false, (Entity)entity);
                stack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
            if ((levelable = (Levelable)stack.getCapability(Capabilities.ITEM_SKILL, (Object)level.registryAccess())) == null) {
                return;
            }
            levelable.addExp(level, blockPos, entity);
        }
    }

    public void breakBlockCollection(ItemStack tool, Level level, Collection<BlockPos> blockPosCollection, LivingEntity entity, float firstBlockSpeed) {
        this.breakBlockCollection(tool, level, blockPosCollection, entity, firstBlockSpeed, false);
    }

    public void breakBlockCollection(ItemStack tool, Level level, Collection<BlockPos> blockPosCollection, LivingEntity entity, float firstBlockSpeed, boolean sendServerPackets) {
        for (BlockPos pos : blockPosCollection) {
            if (!(level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) <= firstBlockSpeed + 20.0f)) continue;
            this.breakBlock(tool, level, pos, entity);
            if (!sendServerPackets) continue;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new BlockBreakPayload(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        this.levelableInventoryTick(itemStack, (Level)level, entity, slot, 1.0);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durability = this.getMaxDamage(stack) - stack.getDamageValue();
        float unbreakingLevel = ((Float)stack.getOrDefault(DataComponents.UNBREAKING, (Object)Float.valueOf(0.0f))).floatValue();
        int damageToTake = 0;
        while (amount > 0) {
            if ((double)unbreakingLevel < Math.random()) {
                ++damageToTake;
            }
            --amount;
        }
        if (durability - damageToTake <= 0) {
            return 0;
        }
        return damageToTake;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.is(oldStack.getItem());
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (((Boolean)stack.getOrDefault(DataComponents.SHEAR, (Object)false)).booleanValue() && entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            if (entity.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockPos pos = BlockPos.containing((Position)entity.position());
            if (target.isShearable(player, stack, entity.level(), pos)) {
                List drops = target.onSheared(player, stack, entity.level(), pos);
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.spawnAtLocation((ServerLevel)entity.level(), d, 1.0f);
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

