/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.levelable.tool;

import com.mojang.serialization.Codec;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum UseMode implements StringRepresentable
{
    HOE,
    SHOVEL,
    AXE,
    TORCH;

    public static Codec<UseMode> CODEC;
    public static StreamCodec<FriendlyByteBuf, UseMode> STREAM_CODEC;

    public static UseMode nextMode(ItemStack tool, UseMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return SHOVEL;
            }
            case 1: {
                return AXE;
            }
            case 2: {
                if (((Boolean)tool.getOrDefault(DataComponents.TORCH, (Object)false)).booleanValue()) {
                    return TORCH;
                }
                return HOE;
            }
            case 3: {
                return HOE;
            }
        }
        return HOE;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromEnum(UseMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(UseMode.class);
    }
}

