/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.data;

import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record BackpackScreenPayload(BackpackAction pickupType, boolean hasShiftDown) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BackpackScreenPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"backpack_screen"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackScreenPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(BackpackAction.class), BackpackScreenPayload::pickupType, (StreamCodec)ByteBufCodecs.BOOL, BackpackScreenPayload::hasShiftDown, BackpackScreenPayload::new);

    public BackpackScreenPayload(BackpackAction pickupType) {
        this(pickupType, false);
    }

    public CustomPacketPayload.Type<? extends BackpackScreenPayload> type() {
        return TYPE;
    }

    public static enum BackpackAction {
        PICKUP_WHITELIST,
        PICKUP_BLACKLIST,
        SORT,
        COMPRESS,
        OPEN_COMPRESSION,
        OPEN_FILTER,
        MATCH_CONTENTS,
        CLEAR_FILTERS,
        CLOSE_SUB_SCREEN,
        REOPEN_BACKPACK,
        OPEN_SETTINGS;


        public static BackpackAction fromSubScreenType(SubScreenType subScreenType) {
            return switch (subScreenType) {
                default -> throw new MatchException(null, null);
                case SubScreenType.NONE -> CLOSE_SUB_SCREEN;
                case SubScreenType.FILTER -> OPEN_FILTER;
                case SubScreenType.COMPRESS -> OPEN_COMPRESSION;
                case SubScreenType.SETTINGS -> OPEN_SETTINGS;
            };
        }
    }
}

