/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.tool.UseMode;
import dev.willyelton.crystal_tools.common.network.data.ModeSwitchPayload;
import dev.willyelton.crystal_tools.utils.AttributeUtils;
import dev.willyelton.crystal_tools.utils.EnchantmentUtils;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import dev.willyelton.crystal_tools.utils.RegistryUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ModeSwitchHandler {
    public static final ModeSwitchHandler INSTANCE = new ModeSwitchHandler();

    public void handle(ModeSwitchPayload payload, IPayloadContext context) {
        Player player = context.player();
        ItemStack tool = ItemStackUtils.getHeldLevelableTool(player);
        if (payload.magnet()) {
            if (tool.is((Item)Registration.CRYSTAL_MAGNET.get())) {
                this.toggleMagnet(player, tool, payload.hasShiftDown());
            } else {
                InventoryUtils.findAll(player, stack -> stack.is((Item)Registration.CRYSTAL_MAGNET.get())).forEach(stack -> this.toggleMagnet(player, (ItemStack)stack, payload.hasShiftDown()));
            }
            return;
        }
        if (tool.isEmpty()) {
            InventoryUtils.getArmorItems(player).forEach(stack -> {
                SkillData skillData = RegistryUtils.getSkillData(stack, player.level().registryAccess());
                if (skillData != null) {
                    if (payload.hasShiftDown()) {
                        this.disableFrostWalker(player, (ItemStack)stack);
                    } else if (payload.hasCtrlDown()) {
                        this.disableCreativeFlight(player, (ItemStack)stack, skillData);
                    } else {
                        this.disableNightVision(player, (ItemStack)stack);
                    }
                }
            });
            return;
        }
        if (((Boolean)tool.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue()) {
            if (payload.hasShiftDown() && !payload.hasCtrlDown() && !payload.hasAltDown()) {
                if (((Boolean)tool.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue()) {
                    boolean disable3x3 = (Boolean)tool.getOrDefault(DataComponents.DISABLE_3x3, (Object)false);
                    tool.set(DataComponents.DISABLE_3x3, (Object)(!disable3x3 ? 1 : 0));
                    player.displayClientMessage((Component)Component.literal((String)("Break Mode: " + (!disable3x3 ? "1x1" : "3x3"))), true);
                }
            } else if (payload.hasCtrlDown() && !payload.hasShiftDown() && !payload.hasAltDown()) {
                if (((Boolean)tool.getOrDefault(DataComponents.AUTO_SMELT, (Object)false)).booleanValue()) {
                    boolean disableAutoSmelt = (Boolean)tool.getOrDefault(DataComponents.DISABLE_AUTO_SMELT, (Object)false);
                    tool.set(DataComponents.DISABLE_AUTO_SMELT, (Object)(!disableAutoSmelt ? 1 : 0));
                    player.displayClientMessage((Component)Component.literal((String)("Auto Smelt " + (!disableAutoSmelt ? "Disabled" : "Enabled"))), true);
                }
            } else if (EnchantmentUtils.hasEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) && (Integer)tool.getOrDefault(DataComponents.FORTUNE_BONUS, (Object)0) > 0) {
                EnchantmentUtils.removeEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH);
                EnchantmentUtils.addEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.FORTUNE, (Integer)tool.getOrDefault(DataComponents.FORTUNE_BONUS, (Object)3), player);
                player.displayClientMessage((Component)Component.literal((String)"Mine Mode: Fortune"), true);
            } else if (EnchantmentUtils.hasEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.FORTUNE) && ((Boolean)tool.getOrDefault(DataComponents.SILK_TOUCH_BONUS, (Object)false)).booleanValue()) {
                EnchantmentUtils.removeEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.FORTUNE);
                EnchantmentUtils.addEnchantment(tool, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, 1, player);
                player.displayClientMessage((Component)Component.literal((String)"Mine Mode: Silk Touch"), true);
            }
        }
        if (payload.hasAltDown() && !payload.hasShiftDown() && !payload.hasCtrlDown() && tool.is((Item)Registration.CRYSTAL_AIOT.get())) {
            UseMode currentMode = (UseMode)((Object)tool.getOrDefault(DataComponents.USE_MODE, (Object)UseMode.HOE));
            tool.set(DataComponents.USE_MODE, (Object)UseMode.nextMode(tool, currentMode));
            player.displayClientMessage((Component)Component.literal((String)("Mode: " + String.valueOf((Object)UseMode.nextMode(tool, currentMode)))), true);
        }
        if (tool.is((Item)Registration.CRYSTAL_BACKPACK.get())) {
            boolean pickupDisabled = (Boolean)tool.getOrDefault(DataComponents.PICKUP_DISABLED, (Object)false);
            tool.set(DataComponents.PICKUP_DISABLED, (Object)(!pickupDisabled ? 1 : 0));
            player.displayClientMessage((Component)Component.literal((String)("Auto Pickup " + (pickupDisabled ? "Enabled" : "Disabled"))), true);
        }
        if (((Boolean)tool.getOrDefault(DataComponents.MINE_MODE, (Object)false)).booleanValue() && tool.is((Item)Registration.CRYSTAL_TRIDENT.get())) {
            boolean riptideDisabled = (Boolean)tool.getOrDefault(DataComponents.RIPTIDE_DISABLED, (Object)false);
            tool.set(DataComponents.RIPTIDE_DISABLED, (Object)(!riptideDisabled ? 1 : 0));
            player.displayClientMessage((Component)Component.literal((String)("Riptide " + (riptideDisabled ? "Enabled" : "Disabled"))), true);
        }
        if (((Boolean)tool.getOrDefault(DataComponents.AUTO_TARGET, (Object)false)).booleanValue() && payload.hasShiftDown()) {
            boolean autoTargetDisabled = (Boolean)tool.getOrDefault(DataComponents.DISABLE_AUTO_TARGET, (Object)false);
            tool.set(DataComponents.DISABLE_AUTO_TARGET, (Object)(!autoTargetDisabled ? 1 : 0));
            player.displayClientMessage((Component)Component.literal((String)("Auto Target " + (autoTargetDisabled ? "Enabled" : "Disabled"))), true);
        }
        SkillData skillData = RegistryUtils.getSkillData(tool, player.level().registryAccess());
        this.disableCreativeFlight(player, tool, skillData);
        this.disableNightVision(player, tool);
        this.disableFrostWalker(player, tool);
    }

    private void disableNightVision(Player player, ItemStack stack) {
        if (stack.is((Item)Registration.CRYSTAL_HELMET.get()) && ((Boolean)stack.getOrDefault(DataComponents.NIGHT_VISION, (Object)false)).booleanValue()) {
            boolean disableNightVision = (Boolean)stack.getOrDefault(DataComponents.DISABLE_NIGHT_VISION, (Object)false);
            stack.set(DataComponents.DISABLE_NIGHT_VISION, (Object)(!disableNightVision ? 1 : 0));
            player.displayClientMessage((Component)Component.literal((String)("Night Vision " + (disableNightVision ? "Enabled" : "Disabled"))), true);
        }
    }

    private void disableCreativeFlight(Player player, ItemStack stack, SkillData skillData) {
        if (((Boolean)stack.getOrDefault(DataComponents.CREATIVE_FLIGHT, (Object)false)).booleanValue()) {
            boolean added = AttributeUtils.toggleAttribute(stack, (Holder<Attribute>)NeoForgeMod.CREATIVE_FLIGHT, skillData);
            player.displayClientMessage((Component)Component.literal((String)("Creative Flight " + (added ? "Enabled" : "Disabled"))), true);
        }
    }

    private void disableFrostWalker(Player player, ItemStack stack) {
        if (((Boolean)stack.getOrDefault(DataComponents.FROST_WALKER, (Object)false)).booleanValue() || EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER)) {
            if (EnchantmentUtils.hasEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER)) {
                EnchantmentUtils.removeEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER);
                stack.set(DataComponents.FROST_WALKER, (Object)true);
                player.displayClientMessage((Component)Component.literal((String)"Frost Walker Disabled"), true);
            } else if (((Boolean)stack.getOrDefault(DataComponents.FROST_WALKER, (Object)false)).booleanValue()) {
                EnchantmentUtils.addEnchantment(stack, (ResourceKey<Enchantment>)Enchantments.FROST_WALKER, 2, player);
                player.displayClientMessage((Component)Component.literal((String)"Frost Walker Enabled"), true);
            }
        }
    }

    private void toggleMagnet(Player player, ItemStack stack, boolean shift) {
        if (shift) {
            if (((Boolean)stack.getOrDefault(DataComponents.PULL_MOBS, (Object)false)).booleanValue()) {
                boolean disabled = (Boolean)stack.getOrDefault(DataComponents.DISABLE_MOB_PULL, (Object)false);
                stack.set(DataComponents.DISABLE_MOB_PULL, (Object)(!disabled ? 1 : 0));
                player.displayClientMessage((Component)Component.literal((String)("Pulling Mobs " + (disabled ? "Enabled" : "Disabled"))), true);
            }
        } else {
            boolean disabled = (Boolean)stack.getOrDefault(DataComponents.DISABLED, (Object)false);
            stack.set(DataComponents.DISABLED, (Object)(!disabled ? 1 : 0));
            player.displayClientMessage((Component)Component.literal((String)("Magnet " + (disabled ? "Enabled" : "Disabled"))), true);
        }
    }
}

