/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.network.handler;

import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.common.levelable.LevelableTooltip;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillPoints;
import dev.willyelton.crystal_tools.common.levelable.skill.node.ItemStackNode;
import dev.willyelton.crystal_tools.common.levelable.skill.node.SkillDataNode;
import dev.willyelton.crystal_tools.common.network.data.ToolSkillPayload;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import dev.willyelton.crystal_tools.utils.StringUtils;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ToolSkillHandler {
    public static final ToolSkillHandler INSTANCE = new ToolSkillHandler();

    public void handle(ToolSkillPayload payload, IPayloadContext context) {
        SkillData data;
        SkillDataNode node;
        Optional dataOptional;
        Level level;
        Optional skillDataOptional;
        Player player = context.player();
        ItemStack heldTool = ItemStackUtils.getHeldLevelableTool(player);
        if (!heldTool.isEmpty() && (skillDataOptional = (level = player.level()).registryAccess().lookup(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS)).isPresent() && (dataOptional = ((Registry)skillDataOptional.get()).get(payload.key())).isPresent() && (node = (data = (SkillData)((Holder.Reference)dataOptional.get()).value()).getNodeMap().get(payload.nodeId())) instanceof ItemStackNode) {
            ItemStackNode itemStackNode = (ItemStackNode)((Object)node);
            SkillPoints points = ((SkillPoints)heldTool.getOrDefault(DataComponents.SKILL_POINT_DATA, (Object)new SkillPoints())).copy();
            int skillPoints = (Integer)heldTool.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
            int toSpend = Math.min(skillPoints, payload.pointsToSpend());
            points.addPoints(payload.nodeId(), toSpend);
            heldTool.set(DataComponents.SKILL_POINT_DATA, (Object)points);
            DataComponents.addToComponent(heldTool, DataComponents.SKILL_POINTS, -toSpend);
            this.editSkillTooltips(heldTool, node.getName(), toSpend);
            itemStackNode.processNode(data, heldTool, toSpend, level.registryAccess());
        }
    }

    private void editSkillTooltips(ItemStack stack, String name, int points) {
        LevelableTooltip tooltip = (LevelableTooltip)stack.getOrDefault(DataComponents.SKILL_TOOLTIP, (Object)new LevelableTooltip(new HashMap<String, Float>()));
        HashMap<String, Float> skills = new HashMap<String, Float>(tooltip.skills());
        skills.compute(StringUtils.stripRomanNumeral(name), (key, value) -> Float.valueOf(value != null ? value.floatValue() + (float)points : (float)points));
        stack.set(DataComponents.SKILL_TOOLTIP, (Object)new LevelableTooltip(skills));
    }
}

