/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.common.crafting.CrystalAIOTRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalElytraRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalGeneratorRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalQuarryRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalShieldTotemRecipe;
import dev.willyelton.crystal_tools.common.crafting.CrystalSmithingRecipe;
import dev.willyelton.crystal_tools.common.tags.CrystalToolsTags;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrystalToolsRecipes
extends RecipeProvider {
    private static final Criterion<InventoryChangeTrigger.TriggerInstance> HAS_CRYSTAL = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registration.CRYSTAL.get()});

    public CrystalToolsRecipes(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    protected void buildRecipes() {
        this.shapeless(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL.get(), 9).requires((ItemLike)Registration.CRYSTAL_BLOCK.get()).unlockedBy("has_crystal_block", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registration.CRYSTAL_BLOCK.get()})).save(this.output);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)Registration.CRYSTAL_BLOCK.get()).pattern("ccc").pattern("ccc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.NETHERITE_STICK.get(), 4).pattern("n").pattern("n").define(Character.valueOf('n'), Tags.Items.INGOTS_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_TORCH.get(), 4).pattern("c").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), (ItemLike)Items.STICK).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.get()).pattern("iii").pattern("ici").pattern("ini").define(Character.valueOf('i'), (ItemLike)Registration.NETHERITE_INFUSED_CRYSTAL_SHARD.get()).define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.get(), 2).requires((ItemLike)Registration.CRYSTAL.get()).requires((ItemLike)Registration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.get()).requires((ItemLike)Items.NETHERITE_INGOT).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output, String.valueOf(Registration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.getId()) + "_dupe");
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_AXE.get()).pattern("cc").pattern("cs").pattern(" s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_HOE.get()).pattern("cc").pattern(" s").pattern(" s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_PICKAXE.get()).pattern("ccc").pattern(" s ").pattern(" s ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_SHOVEL.get()).pattern("c").pattern("s").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)Registration.CRYSTAL_SWORD.get()).pattern("c").pattern("c").pattern("s").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)Registration.CRYSTAL_BOW.get()).pattern(" sc").pattern("s c").pattern(" sc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.FOOD, (ItemLike)Registration.CRYSTAL_APPLE.get()).pattern("ccc").pattern("cac").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('a'), (ItemLike)Items.ENCHANTED_GOLDEN_APPLE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_ROCKET.get()).pattern("ccc").pattern("crc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('r'), (ItemLike)Items.FIREWORK_ROCKET).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_TRIDENT.get()).pattern("ccc").pattern("sts").pattern(" s ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Items.TRIDENT).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_FISHING_ROD.get()).pattern("  s").pattern(" st").pattern("s c").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Items.STRING).define(Character.valueOf('s'), CrystalToolsTags.RODS_METAL_NETHERITE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_SHIELD.get()).pattern(" c ").pattern("tsc").pattern(" c ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('t'), (ItemLike)Registration.NETHERITE_STICK.get()).define(Character.valueOf('s'), (ItemLike)Items.SHIELD).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_BACKPACK.get()).pattern("lcl").pattern("chc").pattern("lcl").define(Character.valueOf('l'), (ItemLike)Items.LEATHER).define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('h'), (ItemLike)Items.CHEST).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.CRYSTAL_MAGNET.get()).pattern(" cr").pattern("cic").pattern("rc ").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)Registration.PORTABLE_GENERATOR.get()).pattern(" p ").pattern("pgp").pattern(" s ").define(Character.valueOf('p'), (ItemLike)Items.PISTON).define(Character.valueOf('g'), (ItemLike)Registration.CRYSTAL_GENERATOR.get()).define(Character.valueOf('s'), (ItemLike)Registration.NETHERITE_STICK.get()).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_FURNACE.get()).pattern("ccc").pattern("cfc").pattern("ccc").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('f'), (ItemLike)Items.FURNACE).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.QUARRY_STABILIZER.get(), 4).pattern("c").pattern("n").define(Character.valueOf('c'), (ItemLike)Registration.CRYSTAL.get()).define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_INGOT).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)Registration.CRYSTAL_PEDESTAL.get()).pattern("n").pattern("b").pattern("c").define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('b'), (ItemLike)Registration.CRYSTAL_BLOCK.get()).define(Character.valueOf('c'), (ItemLike)Items.CHEST).unlockedBy("has_crystal", HAS_CRYSTAL).save(this.output);
        SpecialRecipeBuilder.special(CrystalAIOTRecipe::new).save(this.output, Registration.CRYSTAL_AIOT.getId().toString());
        SpecialRecipeBuilder.special(CrystalElytraRecipe::new).save(this.output, Registration.CRYSTAL_ELYTRA.getId().toString());
        SpecialRecipeBuilder.special(CrystalGeneratorRecipe::new).save(this.output, Registration.CRYSTAL_GENERATOR_ITEM.getId().toString());
        SpecialRecipeBuilder.special(CrystalQuarryRecipe::new).save(this.output, Registration.CRYSTAL_QUARRY_ITEM.getId().toString());
        SpecialRecipeBuilder.special(CrystalShieldTotemRecipe::new).save(this.output, String.valueOf(Registration.CRYSTAL_SHIELD.getId()) + "_totem");
        this.crystalSmithing(Items.NETHERITE_HELMET, Registration.CRYSTAL_HELMET, this.output);
        this.crystalSmithing(Items.NETHERITE_CHESTPLATE, Registration.CRYSTAL_CHESTPLATE, this.output);
        this.crystalSmithing(Items.NETHERITE_LEGGINGS, Registration.CRYSTAL_LEGGINGS, this.output);
        this.crystalSmithing(Items.NETHERITE_BOOTS, Registration.CRYSTAL_BOOTS, this.output);
    }

    protected void crystalSmithing(Item ingredientItem, DeferredHolder<Item, ? extends Item> resultItem, RecipeOutput output) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)(String.valueOf(resultItem.getId()) + "_smithing")));
        Advancement.Builder advancement$builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)resourceKey)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)resourceKey)).requirements(AdvancementRequirements.Strategy.OR).addCriterion("has_crystal", HAS_CRYSTAL);
        CrystalSmithingRecipe smithingtransformrecipe = new CrystalSmithingRecipe(Optional.of(Ingredient.of((ItemLike)((ItemLike)Registration.CRYSTAL_UPGRADE_SMITHING_TEMPLATE.get()))), Ingredient.of((ItemLike)ingredientItem), Optional.of(Ingredient.of((ItemLike)((ItemLike)Registration.CRYSTAL.get()))), new TransmuteResult((Item)resultItem.get()));
        output.accept(resourceKey, (Recipe)smithingtransformrecipe, advancement$builder.build(resourceKey.location().withPrefix("recipes/" + RecipeCategory.TOOLS.getFolderName() + "/")));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
            return new CrystalToolsRecipes(provider, output);
        }

        public String getName() {
            return "crystal_tools:recipes";
        }
    }
}

