/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.datagen;

import dev.willyelton.crystal_tools.common.events.DatapackRegistryEvents;
import dev.willyelton.crystal_tools.datagen.CrystalToolsBlockSkillTrees;
import dev.willyelton.crystal_tools.datagen.CrystalToolsBlockTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsDataMaps;
import dev.willyelton.crystal_tools.datagen.CrystalToolsEntityTypeTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsItemSkillTrees;
import dev.willyelton.crystal_tools.datagen.CrystalToolsItemTags;
import dev.willyelton.crystal_tools.datagen.CrystalToolsLootTables;
import dev.willyelton.crystal_tools.datagen.CrystalToolsModels;
import dev.willyelton.crystal_tools.datagen.CrystalToolsRecipes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="crystal_tools")
public class DataGeneration {
    @SubscribeEvent
    public static void generate(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new CrystalToolsModels(packOutput));
        CrystalToolsBlockTags blockTags = new CrystalToolsBlockTags(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        CrystalToolsItemTags itemTags = new CrystalToolsItemTags(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)itemTags);
        CrystalToolsEntityTypeTags entityTypeTags = new CrystalToolsEntityTypeTags(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)entityTypeTags);
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CrystalToolsLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        event.createProvider(CrystalToolsRecipes.Runner::new);
        CrystalToolsDataMaps dataMaps = new CrystalToolsDataMaps(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)dataMaps);
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_ITEMS, CrystalToolsItemSkillTrees::register).add(DatapackRegistryEvents.SKILL_DATA_REGISTRY_KEY_BLOCKS, CrystalToolsBlockSkillTrees::register), Set.of("crystal_tools", "minecraft"));
    }
}

