/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeUtils {
    private AttributeUtils() {
    }

    public static boolean toggleAttribute(ItemStack stack, Holder<Attribute> attribute, SkillData data) {
        if (data.getEquipmentSlot() == null) {
            return false;
        }
        ItemAttributeModifiers modifiers = stack.getAttributeModifiers();
        ArrayList<ItemAttributeModifiers.Entry> newModifiers = new ArrayList<ItemAttributeModifiers.Entry>();
        boolean found = false;
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (!((Attribute)entry.attribute().value()).equals(attribute.value())) {
                newModifiers.add(entry);
                continue;
            }
            found = true;
        }
        if (!found) {
            ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)attribute.getKey().location().getPath());
            newModifiers.add(new ItemAttributeModifiers.Entry(attribute, new AttributeModifier(rl, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)data.getEquipmentSlot())));
        }
        stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)new ItemAttributeModifiers(newModifiers));
        return !found;
    }
}

