/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantmentUtils {
    public static void addEnchantment(ItemStack stack, ResourceKey<Enchantment> enchantment, int level, Player player) {
        Registry lookup = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        mutable.set((Holder)lookup.getOrThrow(enchantment), level);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
    }

    public static void removeEnchantment(ItemStack stack, ResourceKey<Enchantment> enchantment) {
        ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        mutable.removeIf(enchantmentHolder -> EnchantmentUtils.enchantmentMatches((Holder<Enchantment>)enchantmentHolder, enchantment));
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
    }

    public static boolean hasEnchantment(ItemStack stack, ResourceKey<Enchantment> enchantment) {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet().stream().anyMatch(enchantmentHolder -> EnchantmentUtils.enchantmentMatches((Holder<Enchantment>)enchantmentHolder, enchantment));
    }

    private static boolean enchantmentMatches(Holder<Enchantment> holder, ResourceKey<Enchantment> enchantment) {
        return holder.unwrapKey().isPresent() && ((ResourceKey)holder.unwrapKey().get()).equals(enchantment);
    }

    public static int pointsFromEnchantments(ItemStack stack) {
        return EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).entrySet().stream().mapToInt(Object2IntMap.Entry::getIntValue).sum();
    }
}

