/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import dev.willyelton.crystal_tools.common.capability.Capabilities;
import dev.willyelton.crystal_tools.common.capability.Levelable;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemStackUtils {
    public static ItemStack getHeldLevelableTool(Player player) {
        for (ItemStack i : InventoryUtils.getHandItems(player)) {
            Levelable levelable = (Levelable)i.getCapability(Capabilities.ITEM_SKILL, (Object)player.level().registryAccess());
            if (levelable == null) continue;
            return i;
        }
        return ItemStack.EMPTY;
    }

    public static boolean sameItem(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.is(itemStack2.getItem());
    }

    public static String toString(ItemStack stack) {
        if (stack.isEmpty()) {
            return "Empty Stack";
        }
        return String.format("%d x %s", stack.getCount(), stack.getItem());
    }

    public static void removeAllComponents(ItemStack stack) {
        stack.getComponentsPatch().entrySet().forEach(entry -> stack.remove((DataComponentType)entry.getKey()));
    }
}

