/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.utils;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceUtils {
    public static BlockHitResult rayTrace(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        double reach = attributeInstance == null ? 5.0 : attributeInstance.getValue();
        Vec3 look = entity.getLookAngle();
        Vec3 start = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 end = new Vec3(entity.getX() + look.x * reach, entity.getY() + (double)entity.getEyeHeight() + look.y * reach, entity.getZ() + look.z * reach);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(context);
    }
}

