/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.events;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.model.CrystalElytraLayer;
import dev.willyelton.crystal_tools.client.renderer.CrystalTridentBlockEntityWithoutLevelRenderer;
import dev.willyelton.crystal_tools.client.renderer.CrystalTridentRenderer;
import dev.willyelton.crystal_tools.client.renderer.QuarryCubeRenderer;
import dev.willyelton.crystal_tools.client.renderer.blockentity.CrystalPedestalBlockEntityRenderer;
import dev.willyelton.crystal_tools.client.renderer.blockentity.CrystalQuarryBlockEntityRenderer;
import dev.willyelton.crystal_tools.common.levelable.tool.BowLevelableItem;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.common.ItemAbilities;

@EventBusSubscriber(modid="crystal_tools", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void setModelProperties(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)Registration.CRYSTAL_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BowLevelableItem) {
                BowLevelableItem bowItem = (BowLevelableItem)patt0$temp;
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / bowItem.getChargeTime(stack);
            }
            return 0.0f;
        });
        ItemProperties.register((Item)((Item)Registration.CRYSTAL_BOW.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)Registration.CRYSTAL_TRIDENT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"throwing"), (pStack, pLevel, pEntity, pSeed) -> pEntity != null && pEntity.isUsingItem() && pEntity.getUseItem() == pStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)Registration.CRYSTAL_FISHING_ROD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"cast"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            boolean flag = entity.getMainHandItem() == stack;
            boolean flag1 = entity.getOffhandItem() == stack && !entity.getMainHandItem().getItem().canPerformAction(stack, ItemAbilities.FISHING_ROD_CAST);
            return (flag || flag1) && entity instanceof Player && ((Player)entity).fishing != null ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)Registration.CRYSTAL_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        EntityModelSet entityModels = event.getEntityModels();
        event.getSkins().forEach(s -> {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)event.getSkin(s);
            if (livingEntityRenderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)livingEntityRenderer;
                playerRenderer.addLayer(new CrystalElytraLayer(playerRenderer, entityModels, new HumanoidArmorModel(event.getContext().bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR))));
            }
        });
        LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)event.getRenderer(EntityType.ARMOR_STAND);
        if (livingEntityRenderer instanceof ArmorStandRenderer) {
            ArmorStandRenderer armorStandRenderer = (ArmorStandRenderer)livingEntityRenderer;
            armorStandRenderer.addLayer(new CrystalElytraLayer(armorStandRenderer, entityModels, new ArmorStandArmorModel(event.getContext().bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR))));
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Registration.CRYSTAL_TRIDENT_ENTITY.get(), CrystalTridentRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.CRYSTAL_QUARRY_BLOCK_ENTITY.get(), CrystalQuarryBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.CRYSTAL_PEDESTAL_BLOCK_ENTITY.get(), CrystalPedestalBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(QuarryCubeRenderer.LOCATION, QuarryCubeRenderer::createBodyLayer);
    }

    @SubscribeEvent
    public static void loadModels(ModelEvent.RegisterAdditional event) {
        event.register(CrystalTridentBlockEntityWithoutLevelRenderer.CRYSTAL_TRIDENT_MODEL_RESOURCE_LOCATION);
    }

    private static boolean stacksSame(ItemStack stack1, ItemStack stack2) {
        return stack1.is(stack2.getItem());
    }
}

