/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.events;

import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.common.network.data.ModeSwitchPayload;
import dev.willyelton.crystal_tools.common.network.data.OpenBackpackPayload;
import dev.willyelton.crystal_tools.common.network.data.TriggerRocketPayload;
import dev.willyelton.crystal_tools.common.network.data.VeinMiningPayload;
import dev.willyelton.crystal_tools.utils.ItemStackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="crystal_tools", value={Dist.CLIENT})
public class KeyPressEvent {
    @SubscribeEvent
    public static void handleEventInput(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (mc.player == null || level == null) {
            return;
        }
        if (RegisterKeyBindingsEvent.UPGRADE_MENU.consumeClick()) {
            ItemStack levelableTool = ItemStackUtils.getHeldLevelableTool((Player)mc.player);
            KeyPressEvent.handleUpgradeMenu(levelableTool, (Player)mc.player);
        }
        if (RegisterKeyBindingsEvent.MODE_SWITCH.consumeClick()) {
            KeyPressEvent.handleModeSwitch(false);
        }
        if (RegisterKeyBindingsEvent.TOGGLE_MAGNET.consumeClick()) {
            KeyPressEvent.handleModeSwitch(true);
        }
        if (RegisterKeyBindingsEvent.OPEN_BACKPACK.consumeClick()) {
            KeyPressEvent.handleOpenBackpack();
        }
        if (RegisterKeyBindingsEvent.TRIGGER_ROCKET.consumeClick()) {
            KeyPressEvent.handleTriggerRocket();
        }
        if (level.getGameTime() % 5L == 0L) {
            PacketDistributor.sendToServer((CustomPacketPayload)new VeinMiningPayload(RegisterKeyBindingsEvent.VEIN_MINE.isDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void handleUpgradeMenu(ItemStack levelableTool, Player player) {
        if (!levelableTool.isEmpty()) {
            ModGUIs.openScreen(new UpgradeScreen(levelableTool, player));
        }
    }

    public static void handleModeSwitch(boolean magnet) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ModeSwitchPayload(Screen.hasShiftDown(), Screen.hasControlDown(), Screen.hasAltDown(), magnet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleOpenBackpack() {
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenBackpackPayload(-1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleTriggerRocket() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TriggerRocketPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

