/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.events;

import dev.willyelton.crystal_tools.client.config.CrystalToolsClientConfig;
import dev.willyelton.crystal_tools.client.events.RegisterKeyBindingsEvent;
import dev.willyelton.crystal_tools.client.renderer.BlockOverlayRenderer;
import dev.willyelton.crystal_tools.client.renderer.QuarryLaserRenderer;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.VeinMinerLevelableTool;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="crystal_tools", value={Dist.CLIENT})
public class RenderEvents {
    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void handleRenderLevelStageEvent(RenderLevelStageEvent event) {
        Item item;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            QuarryLaserRenderer.render(event);
        }
        if ((Boolean)CrystalToolsClientConfig.DISABLE_BLOCK_TARGET_RENDERING.get() != false) return;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) return;
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (RegisterKeyBindingsEvent.VEIN_MINE.isDown() && (item = stack.getItem()) instanceof VeinMinerLevelableTool) {
            VeinMinerLevelableTool veinMinerLevelableTool = (VeinMinerLevelableTool)item;
            if ((Integer)stack.getOrDefault(DataComponents.VEIN_MINER, (Object)0) > 0) {
                BlockOverlayRenderer.renderVeinMiner(event, veinMinerLevelableTool, stack);
                return;
            }
        }
        if (!((item = stack.getItem()) instanceof LevelableTool)) return;
        LevelableTool toolItem = (LevelableTool)item;
        if ((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false) == false) return;
        if ((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false) != false) return;
        BlockOverlayRenderer.render3x3(event, toolItem, stack);
    }

    @SubscribeEvent
    public static void handleHighlightEvent(RenderHighlightEvent.Block event) {
        if (((Boolean)CrystalToolsClientConfig.DISABLE_BLOCK_TARGET_RENDERING.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        BlockHitResult blockHitResult = event.getTarget();
        if (blockHitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult2 = blockHitResult;
            BlockState state = player.level().getBlockState(blockHitResult2.getBlockPos());
            ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
            Item item = stack.getItem();
            if (item instanceof LevelableTool) {
                LevelableTool toolItem = (LevelableTool)item;
                if (((Boolean)stack.getOrDefault(DataComponents.HAS_3x3, (Object)false)).booleanValue() && !((Boolean)stack.getOrDefault(DataComponents.DISABLE_3x3, (Object)false)).booleanValue() && toolItem.correctTool(stack, state)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

