/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.config.CrystalToolsClientConfig;
import dev.willyelton.crystal_tools.client.gui.component.SkillButton;
import dev.willyelton.crystal_tools.client.gui.component.XpButton;
import dev.willyelton.crystal_tools.common.config.CrystalToolsConfig;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillSubText;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeOrSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.NotNodeSkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.RequirementType;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataNodeRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillDataRequirement;
import dev.willyelton.crystal_tools.common.levelable.skill.requirement.SkillItemRequirement;
import dev.willyelton.crystal_tools.common.network.data.RemoveItemPayload;
import dev.willyelton.crystal_tools.common.network.data.RemoveXpPayload;
import dev.willyelton.crystal_tools.utils.InventoryUtils;
import dev.willyelton.crystal_tools.utils.XpUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public abstract class BaseUpgradeScreen
extends Screen {
    protected static final int Y_PADDING = 30;
    protected static final int X_SIZE = 100;
    protected static final int Y_SIZE = 20;
    protected static final int MIN_X_PADDING = 5;
    private static final ResourceLocation DEPENDENCY_LINE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/dependency_line.png");
    private static final float DEPENDENCY_LINE_WIDTH = 9.0f;
    private static final int DEPENDENCY_LINE_IMAGE_WIDTH = 252;
    private static final int DEPENDENCY_LINE_IMAGE_HEIGHT = 256;
    private static int ANIMATION_FRAME = 0;
    private static final int ANIMATION_FRAME_MIN = 0;
    private static int ANIMATION_COUNTER = 0;
    private static final int ANIMATION_COUNTER_MAX = 10;
    protected final Player player;
    protected SkillData data;
    private final HashMap<Integer, SkillButton> skillButtons = new HashMap();
    private int xOffset = 0;
    private int yOffset = 0;
    private XpButton xpButton;
    private Button resetButton;

    public BaseUpgradeScreen(Player player, Component title) {
        super(title);
        this.player = player;
    }

    protected void init() {
        List<List<SkillDataNode>> tiers = this.data.getAllNodesByTier();
        int y = 30;
        for (List<SkillDataNode> tier : tiers) {
            this.addButtonsFromTier(tier, y);
            y += 50;
        }
        this.initComponents();
        this.updateButtons();
    }

    protected void initComponents() {
        if ((Integer)CrystalToolsConfig.EXPERIENCE_PER_SKILL_LEVEL.get() > 0) {
            this.xpButton = (XpButton)this.addRenderableWidget((GuiEventListener)new XpButton(5, this.getXpButtonY(), 30, 20, pButton -> {
                int pointsToGain = this.getPointsToSpend(Integer.MAX_VALUE, BaseUpgradeScreen.hasShiftDown(), BaseUpgradeScreen.hasControlDown());
                int xpCost = this.getXpCost(pointsToGain);
                if (XpUtils.getPlayerTotalXp(this.player) >= (long)xpCost) {
                    this.player.giveExperiencePoints(-xpCost);
                    PacketDistributor.sendToServer((CustomPacketPayload)new RemoveXpPayload(xpCost), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.changeSkillPoints(pointsToGain);
                    this.updateButtons();
                }
            }, (pButton, guiGraphics, mouseX, mouseY) -> {
                MutableComponent textComponent = Component.literal((String)String.format("Use Experience To Gain Skill Points (+%d Points)", this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown())));
                guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
            }, () -> XpUtils.getLevelForXp(this.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown())))));
        }
        boolean resetRequiresCrystal = (Boolean)CrystalToolsConfig.REQUIRE_CRYSTAL_FOR_RESET.get();
        Object text = "Reset Skill Points";
        if (resetRequiresCrystal) {
            text = (String)text + " (Requires 1 Crystal)";
        }
        Tooltip resetTooltip = Tooltip.create((Component)Component.literal((String)text));
        this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reset"), button -> {
            this.resetPoints(resetRequiresCrystal);
            if (resetRequiresCrystal) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RemoveItemPayload(((Item)Registration.CRYSTAL.get()).getDefaultInstance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                InventoryUtils.removeItemFromInventory(this.player.getInventory(), ((Item)Registration.CRYSTAL.get()).getDefaultInstance());
            }
        }).bounds(this.width - 40 - 5, 15, 40, 20).tooltip(resetTooltip).build());
    }

    protected abstract int getXpButtonY();

    protected abstract void changeSkillPoints(int var1);

    protected abstract void resetPoints(boolean var1);

    private int getXpCost(int pointsToGain) {
        int totalPoints = this.data.getTotalPoints() + this.getSkillPoints();
        int xpLevelCost = (Integer)CrystalToolsConfig.EXPERIENCE_PER_SKILL_LEVEL.get();
        int levelScaling = (Integer)CrystalToolsConfig.EXPERIENCE_LEVELING_SCALING.get();
        if (levelScaling > 0) {
            int pointsToSpend;
            int i;
            long totalCost = 0L;
            int pointsAtLowerLevelLeft = Math.min(levelScaling - totalPoints % levelScaling, pointsToGain);
            int pointCost1 = Math.min(totalPoints / levelScaling, 500);
            totalCost += (long)pointsAtLowerLevelLeft * XpUtils.getXPForLevel(xpLevelCost + pointCost1);
            int n = i = pointsAtLowerLevelLeft == 0 ? 0 : 1;
            for (int pointsLeft = pointsToGain - pointsAtLowerLevelLeft; pointsLeft > 0; pointsLeft -= pointsToSpend) {
                pointsToSpend = Math.min(levelScaling, pointsLeft);
                int pointCost = Math.min(totalPoints / levelScaling, 500);
                totalCost += (long)pointsToSpend * XpUtils.getXPForLevel(xpLevelCost + pointCost + i);
                ++i;
            }
            if (totalCost >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)totalCost;
        }
        int totalCost = pointsToGain * xpLevelCost;
        if (totalCost < 0) {
            return Integer.MAX_VALUE;
        }
        return totalCost;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBlockBackground(guiGraphics, (String)CrystalToolsClientConfig.UPGRADE_SCREEN_BACKGROUND.get());
        this.drawDependencyLines(guiGraphics);
        guiGraphics.drawString(this.font, "Skill Points: " + this.getSkillPoints(), 5, 5, 0xFFFFFF);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (++ANIMATION_COUNTER > 10) {
            ANIMATION_COUNTER = 0;
            if (ANIMATION_FRAME < 0) {
                ANIMATION_FRAME = 11;
            }
            --ANIMATION_FRAME;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderTransparentBackground(guiGraphics);
    }

    protected abstract int getSkillPoints();

    public boolean isPauseScreen() {
        return false;
    }

    private void addButtonsFromTier(List<SkillDataNode> nodes, int y) {
        int paddingX;
        int size = nodes.size();
        int x = paddingX = Math.max((this.width - size * 100) / (size + 1), 5);
        for (SkillDataNode node : nodes) {
            this.addButtonFromNode(node, x, y);
            x += paddingX + 100;
        }
    }

    private void addButtonFromNode(SkillDataNode node, int x, int y) {
        this.addSkillButton(new SkillButton(x, y, 100, 20, (Component)Component.literal((String)node.getName()), button -> this.onSkillButtonPress(node, button), (button, guiGraphics, mouseX, mouseY) -> {
            FormattedText compositeComponent;
            Object text;
            if (node.getLimit() == 0) {
                int pointsToAdd = this.getPointsToSpend(Integer.MAX_VALUE, BaseUpgradeScreen.hasShiftDown(), BaseUpgradeScreen.hasControlDown());
                text = String.format("%s\n%d Points", node.getDescription(), node.getPoints());
                if (pointsToAdd > 1) {
                    text = (String)text + String.format("\n(+ %d Points)", pointsToAdd);
                }
            } else {
                text = String.format("%s\n%d/%d Points", node.getDescription(), node.getPoints(), node.getLimit());
            }
            Optional<SkillSubText> subText = node.getSkillSubText();
            MutableComponent textComponent = Component.literal((String)text);
            if (subText.isPresent()) {
                FormattedText subTextComponent = FormattedText.of((String)("\n" + subText.get().text()), (Style)Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)subText.get().color()).getOrThrow()));
                compositeComponent = FormattedText.composite((FormattedText[])new FormattedText[]{textComponent, subTextComponent});
            } else {
                compositeComponent = FormattedText.composite((FormattedText[])new FormattedText[]{textComponent});
            }
            guiGraphics.renderTooltip(this.font, this.font.split(compositeComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, this.data, node, this.player));
    }

    protected void onSkillButtonPress(SkillDataNode node, Button button) {
        List<SkillDataRequirement> requirements = node.getRequirements();
        for (SkillDataRequirement requirement : requirements) {
            if (!((Boolean)CrystalToolsConfig.ENABLE_ITEM_REQUIREMENTS.get()).booleanValue() || requirement.getRequirementType() != RequirementType.ITEM) continue;
            SkillItemRequirement itemRequirement = (SkillItemRequirement)requirement;
            itemRequirement.getItems().forEach(item -> {
                PacketDistributor.sendToServer((CustomPacketPayload)new RemoveItemPayload(item.getDefaultInstance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                InventoryUtils.removeItemFromInventory(this.player.getInventory(), item.getDefaultInstance());
            });
        }
        this.data.addPoint();
        this.updateButtons();
    }

    private void addSkillButton(SkillButton button) {
        this.skillButtons.put(button.getDataNode().getId(), button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    void updateButtons() {
        int skillPoints = this.getSkillPoints();
        for (SkillButton button : this.skillButtons.values()) {
            SkillDataNode node = button.getDataNode();
            boolean bl = button.active = !button.isComplete && node.canLevel(this.data, this.player) && skillPoints > 0;
            if (!node.isComplete()) continue;
            button.setComplete();
        }
        if (this.xpButton != null) {
            this.xpButton.update(this.getXpCost(1), this.player);
        }
        if (this.resetButton != null) {
            this.resetButton.active = (Boolean)CrystalToolsConfig.REQUIRE_CRYSTAL_FOR_RESET.get() == false || this.player.getInventory().hasAnyOf(Set.of((Item)Registration.CRYSTAL.get()));
        }
    }

    private void drawDependencyLines(GuiGraphics guiGraphics) {
        for (SkillButton button : this.skillButtons.values()) {
            SkillDataNode node = button.getDataNode();
            block6: for (SkillDataRequirement requirement : node.getRequirements()) {
                SkillDataNodeRequirement skillDataNodeRequirement;
                if (!(requirement instanceof SkillDataNodeRequirement)) continue;
                SkillDataNodeRequirement nodeRequirement = (SkillDataNodeRequirement)((Object)requirement);
                int textureY = 0;
                boolean not = false;
                Objects.requireNonNull(nodeRequirement);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NotNodeSkillDataRequirement.class, NodeSkillDataRequirement.class, NodeOrSkillDataRequirement.class}, (Object)skillDataNodeRequirement, n)) {
                    case 0: {
                        NotNodeSkillDataRequirement n2 = (NotNodeSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 27;
                        not = true;
                        if (n2.getUnlessNodes().isEmpty()) break;
                        int unlessNode = n2.getUnlessNodes().getFirst();
                        if (!this.skillButtons.get((Object)Integer.valueOf((int)unlessNode)).isComplete) break;
                        continue block6;
                    }
                    case 1: {
                        NodeSkillDataRequirement ignored = (NodeSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 9;
                        break;
                    }
                    case 2: {
                        NodeOrSkillDataRequirement ignored = (NodeOrSkillDataRequirement)skillDataNodeRequirement;
                        textureY = 18;
                        break;
                    }
                }
                List<Integer> nodes = nodeRequirement.getRequiredNodes();
                for (int j : nodes) {
                    boolean active;
                    if ((!this.skillButtons.containsKey(j) || !this.skillButtons.get(j).isHovered()) && !button.isHovered()) continue;
                    boolean bl = active = this.skillButtons.get(j).getDataNode().getPoints() > 0;
                    if (!active && !not) {
                        textureY = 0;
                    }
                    this.drawDependencyLine(guiGraphics, this.getButtonCenter(this.skillButtons.get(j)), this.getButtonCenter(button), textureY);
                }
            }
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset += (int)dragX;
        this.yOffset += (int)dragY;
        for (SkillButton skillButton : this.skillButtons.values()) {
            skillButton.xOffset = this.xOffset;
            skillButton.yOffset = this.yOffset;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (SkillButton skillButton : this.skillButtons.values()) {
            skillButton.yOffset += (int)scrollY * 10;
        }
        return true;
    }

    private void drawDependencyLine(GuiGraphics guiGraphics, int[] p1, int[] p2, int textureY) {
        this.drawDependencyLine(guiGraphics, p1[0], p1[1], p2[0], p2[1], textureY);
    }

    private void drawDependencyLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int yImageStart) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DEPENDENCY_LINE_LOCATION);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float yImageEnd = (float)yImageStart + 9.0f;
        float length = (float)Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        float angle = (float)Math.atan2(x2 - x1, y2 - y1);
        float xOffset = 3.0f * (float)Math.cos(angle);
        float yOffset = 3.0f * (float)Math.sin(angle);
        float x1F = (float)x1 - xOffset;
        float y1F = (float)y1 + yOffset;
        float x2F = (float)x1 + xOffset;
        float y2F = (float)y1 - yOffset;
        float x3F = (float)x2 + xOffset;
        float y3F = (float)y2 - yOffset;
        float x4F = (float)x2 - xOffset;
        float y4F = (float)y2 + yOffset;
        bufferbuilder.addVertex(matrix4f, x2F, y2F, 0.0f).setUv((float)ANIMATION_FRAME / 252.0f, (float)yImageStart / 256.0f);
        bufferbuilder.addVertex(matrix4f, x1F, y1F, 0.0f).setUv((float)ANIMATION_FRAME / 252.0f, yImageEnd / 256.0f);
        bufferbuilder.addVertex(matrix4f, x4F, y4F, 0.0f).setUv((length + (float)ANIMATION_FRAME) / 252.0f, yImageEnd / 256.0f);
        bufferbuilder.addVertex(matrix4f, x3F, y3F, 0.0f).setUv((length + (float)ANIMATION_FRAME) / 252.0f, (float)yImageStart / 256.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    private int[] getButtonCenter(SkillButton button) {
        int x = button.getX() + button.xOffset + button.getWidth() / 2;
        int y = button.getY() + button.yOffset + button.getHeight() / 2;
        return new int[]{x, y};
    }

    public void renderBlockBackground(GuiGraphics guiGraphics, String block) {
        String[] split = block.split(":");
        ResourceLocation blockResource = split.length == 1 ? ResourceLocation.withDefaultNamespace((String)("textures/block/" + block + ".png")) : ResourceLocation.fromNamespaceAndPath((String)split[0], (String)("textures/block/" + split[1] + ".png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)((Double)CrystalToolsClientConfig.BACKGROUND_OPACITY.get()).doubleValue()));
        BaseUpgradeScreen.renderMenuBackgroundTexture((GuiGraphics)guiGraphics, (ResourceLocation)blockResource, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getPointsToSpend(int points, boolean shiftDown, boolean controlDown) {
        if (controlDown && shiftDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.CONTROL_POINT_SPEND.get() * (Integer)CrystalToolsClientConfig.SHIFT_POINT_SPEND.get());
        }
        if (controlDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.CONTROL_POINT_SPEND.get());
        }
        if (shiftDown) {
            return Math.min(points, (Integer)CrystalToolsClientConfig.SHIFT_POINT_SPEND.get());
        }
        return 1;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 341 || keyCode == 344 || keyCode == 345) {
            this.xpButton.update(this.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown())), this.player);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 341 || keyCode == 344 || keyCode == 345) {
            this.xpButton.update(this.getXpCost(this.getPointsToSpend(Integer.MAX_VALUE, Screen.hasShiftDown(), Screen.hasControlDown())), this.player);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }
}

