/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.gui.BaseUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.SkillButton;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.levelable.block.entity.LevelableBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillData;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillTreeRegistry;
import dev.willyelton.crystal_tools.common.network.data.BlockAttributePayload;
import dev.willyelton.crystal_tools.common.network.data.ResetSkillsBlockPayload;
import java.util.Set;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class BlockEntityUpgradeScreen
extends BaseUpgradeScreen {
    private final LevelableContainerMenu container;
    @Nullable
    private final Screen screen;
    @Nullable
    private final Runnable onClose;

    public BlockEntityUpgradeScreen(LevelableContainerMenu container, Player player, Runnable onClose) {
        super(player, (Component)Component.literal((String)"Upgrade Furnace"));
        this.container = container;
        this.data = this.getSkillData();
        this.screen = null;
        this.onClose = onClose;
    }

    public BlockEntityUpgradeScreen(LevelableContainerMenu container, Player player, Screen toOpen) {
        super(player, (Component)Component.literal((String)"Upgrade Furnace"));
        this.container = container;
        this.data = this.getSkillData();
        this.screen = toOpen;
        this.onClose = null;
    }

    protected SkillData getSkillData() {
        int[] points = this.container.getPoints();
        String blockType = this.container.getBlockType();
        SkillData data = SkillTreeRegistry.SKILL_TREES.get(blockType);
        data.applyPoints(points);
        return data;
    }

    public void onClose() {
        if (this.minecraft != null) {
            if (this.screen != null) {
                this.minecraft.popGuiLayer();
                this.minecraft.setScreen(this.screen);
            }
            if (this.onClose != null) {
                super.onClose();
                this.onClose.run();
            }
        }
    }

    @Override
    protected void onSkillButtonPress(SkillDataNode node, Button button) {
        int skillPoints = this.getSkillPoints();
        boolean shift = BlockEntityUpgradeScreen.hasShiftDown();
        boolean control = BlockEntityUpgradeScreen.hasControlDown();
        if (skillPoints > 0) {
            int pointsToSpend = 1;
            if (node.getLimit() == 0) {
                pointsToSpend = this.getPointsToSpend(skillPoints, shift, control);
            }
            this.container.addToPoints(node.getId(), (int)node.getValue() * pointsToSpend);
            PacketDistributor.sendToServer((CustomPacketPayload)new BlockAttributePayload(node.getKey(), node.getValue(), node.getId(), pointsToSpend), (CustomPacketPayload[])new CustomPacketPayload[0]);
            node.addPoint(pointsToSpend);
            if (node.isComplete()) {
                ((SkillButton)button).setComplete();
            }
            this.changeSkillPoints(-pointsToSpend);
        }
        super.onSkillButtonPress(node, button);
    }

    @Override
    protected void changeSkillPoints(int change) {
        this.container.addSkillPoints(change);
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockAttributePayload("skill_points", change, -1, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void resetPoints(boolean crystalRequired) {
        if (!crystalRequired || this.player.getInventory().hasAnyOf(Set.of((Item)Registration.CRYSTAL.get()))) {
            LevelableBlockEntity blockEntity = this.container.getBlockEntity();
            PacketDistributor.sendToServer((CustomPacketPayload)new ResetSkillsBlockPayload(blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            blockEntity.resetSkills();
            this.data = this.getSkillData();
        }
        this.onClose();
    }

    @Override
    protected int getSkillPoints() {
        return this.container.getSkillPoints();
    }

    @Override
    protected int getXpButtonY() {
        return 15;
    }
}

