/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.willyelton.crystal_tools.client.gui.BlockEntityUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.component.BlockEntityUpgradeButton;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalFurnaceContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceFuelSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceInputSlot;
import dev.willyelton.crystal_tools.common.inventory.container.slot.furnace.CrystalFurnaceOutputSlot;
import dev.willyelton.crystal_tools.utils.IntegerUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class CrystalFurnaceScreen
extends AbstractContainerScreen<CrystalFurnaceContainerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_furnace.png");
    private static final int SLOT_TEXTURE_X = 176;
    private static final int SLOT_TEXTURE_Y = 27;
    private static final int SLOT_TEXTURE_SIZE = 18;
    private static final int ARROW_TEXTURE_X = 188;
    private static final int ARROW_TEXTURE_ON_X = 176;
    private static final int ARROW_TEXTURE_Y = 13;
    private static final int ARROW_WIDTH = 12;
    private static final int ARROW_HEIGHT = 14;
    private static final int FIRE_TEXTURE_X = 189;
    private static final int FIRE_TEXTURE_ON_X = 176;
    private static final int FIRE_TEXTURE_Y = 0;
    private static final int FIRE_TEXTURE_WIDTH = 14;
    private static final int FIRE_TEXTURE_HEIGHT = 13;
    private static final int FUEL_ARROW_TEXTURE_X = 176;
    private static final int FUEL_ARROW_TEXTURE_Y = 45;
    private static final int FUEL_ARROW_TEXTURE_WIDTH = 8;
    private static final int FUEL_ARROW_TEXTURE_HEIGHT = 4;
    private static final int UPGRADE_BUTTON_X = 155;
    private static final int UPGRADE_BUTTON_Y = 6;
    private static final int UPGRADE_BUTTON_WIDTH = 12;
    private static final int UPGRADE_BUTTON_HEIGHT = 12;
    private static final int FUEL_BAR_X = 28;
    private static final int FUEL_BAR_Y = 91;
    private static final int FUEL_BAR_TEXTURE_X = 0;
    private static final int FUEL_BAR_TEXTURE_Y = 191;
    private static final int FUEL_BAR_INITIAL_WIDTH = 44;
    private static final int FUEL_BAR_HEIGHT = 2;
    private static final int FUEL_BAR_WIDTH_INCREASE = 20;
    private static final int FUEL_INSERT_X = 26;
    private static final int FUEL_INSERT_Y = 86;
    private static final int FUEL_INSERT_TEXTURE_X = 0;
    private static final int FUEL_INSERT_TEXTURE_Y = 201;
    private static final int FUEL_INSERT_WIDTH = 6;
    private static final int FUEL_INSERT_HEIGHT = 5;
    private final NonNullList<Slot> slots;
    private final float expLabelX;
    private int counter = 0;
    private final int maxCounter = 15;
    private int animFrame = 0;
    private final int maxAnimFrame = 3;

    public CrystalFurnaceScreen(CrystalFurnaceContainerMenu container, Inventory inventory, Component name) {
        super((AbstractContainerMenu)container, inventory, name);
        this.slots = container.slots;
        this.imageHeight = 191;
        this.inventoryLabelY = this.imageHeight - 94;
        this.expLabelX = this.inventoryLabelX + 112;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderSlots(guiGraphics);
        this.renderFuelBar(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderSlots(GuiGraphics guiGraphics) {
        for (Slot slot : this.slots) {
            int height;
            if (!slot.isActive()) continue;
            guiGraphics.blit(TEXTURE, slot.x - 1 + this.leftPos, slot.y - 1 + this.topPos, 176, 27, 18, 18);
            if (slot instanceof CrystalFurnaceOutputSlot) {
                guiGraphics.blit(TEXTURE, slot.x + 3 + this.leftPos, slot.y + 18 + this.topPos, 188, 13, 12, 14);
                float progress = ((CrystalFurnaceContainerMenu)this.menu).getBurnProgress(slot.index - 5);
                height = (int)(progress * 14.0f);
                guiGraphics.blit(TEXTURE, slot.x + 3 + this.leftPos, slot.y + 18 + this.topPos + 14 - height, 176, 27 - height, 12, height);
                continue;
            }
            if (slot instanceof CrystalFurnaceInputSlot) {
                guiGraphics.blit(TEXTURE, slot.x + 1 + this.leftPos, slot.y + 18 + this.topPos + 2, 189, 0, 14, 13);
                if (!((CrystalFurnaceContainerMenu)this.menu).isLit()) continue;
                float litProgress = ((CrystalFurnaceContainerMenu)this.menu).getLitProgress();
                height = (int)(litProgress * 13.0f);
                guiGraphics.blit(TEXTURE, slot.x + 2 + this.leftPos, slot.y + 18 + this.topPos + 13 - height + 2, 176, 13 - height, 14, height);
                continue;
            }
            if (!(slot instanceof CrystalFurnaceFuelSlot) || slot.index == 10) continue;
            guiGraphics.blit(TEXTURE, slot.x + 4 + this.leftPos, slot.y + 19 + this.topPos, 176, 45, 8, 4);
        }
    }

    private void renderFuelBar(GuiGraphics guiGraphics) {
        if (this.counter > 15) {
            this.counter = 0;
            ++this.animFrame;
            if (this.animFrame > this.maxAnimFrame) {
                this.animFrame = 0;
            }
        }
        ++this.counter;
        int widthIncrease = (((CrystalFurnaceContainerMenu)this.menu).getNumActiveSlots() - 1) * 20;
        guiGraphics.blit(TEXTURE, this.leftPos + 28, this.topPos + 91, 0, 191, 44 + widthIncrease, 2);
        if (((CrystalFurnaceContainerMenu)this.menu).isLit()) {
            guiGraphics.blit(TEXTURE, this.leftPos + 28, this.topPos + 91, 0, 191 + (this.animFrame + 1) * 2, 44 + widthIncrease, 2);
            guiGraphics.blit(TEXTURE, this.leftPos + 26, this.topPos + 86, 0 + this.animFrame * 6, 201, 6, 5);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        int xOffset = (IntegerUtils.getDigits(((CrystalFurnaceContainerMenu)this.menu).getExp()) - 1) * 6 + (IntegerUtils.getDigits(((CrystalFurnaceContainerMenu)this.menu).getExpCap()) - 2) * 6;
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Exp: %d/%d", ((CrystalFurnaceContainerMenu)this.menu).getExp(), ((CrystalFurnaceContainerMenu)this.menu).getExpCap())), (int)(this.expLabelX - (float)xOffset), this.inventoryLabelY, 0x404040, false);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new BlockEntityUpgradeButton(155 + this.leftPos, 6 + this.topPos, 12, 12, (Component)Component.literal((String)"+"), pButton -> ModGUIs.openScreen(new BlockEntityUpgradeScreen((LevelableContainerMenu)this.menu, ((CrystalFurnaceContainerMenu)this.menu).getPlayer(), (Screen)this)), (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)(((CrystalFurnaceContainerMenu)this.menu).getSkillPoints() + " Point(s) Available"));
            guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, false));
    }
}

