/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.willyelton.crystal_tools.CrystalTools;
import dev.willyelton.crystal_tools.client.gui.BlockEntityUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.component.BlockEntityUpgradeButton;
import dev.willyelton.crystal_tools.client.gui.component.EnergyBarWidget;
import dev.willyelton.crystal_tools.common.inventory.container.AbstractGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.EnergyLevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.utils.IntegerUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CrystalGeneratorScreen
extends AbstractContainerScreen<AbstractGeneratorContainerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_generator.png");
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 23;
    private static final int ENERGY_WIDTH = 160;
    private static final int ENERGY_HEIGHT = 10;
    private static final int FIRE_X = 82;
    private static final int FIRE_Y = 78;
    private static final int FIRE_WIDTH = 14;
    private static final int FIRE_HEIGHT = 13;
    private static final int FIRE_TEXTURE_ON_X = 176;
    private static final int FIRE_TEXTURE_OFF_X = 190;
    private static final int FIRE_TEXTURE_Y = 0;
    protected static final int UPGRADE_BUTTON_X = 155;
    protected static final int UPGRADE_BUTTON_Y = 6;
    protected static final int UPGRADE_BUTTON_WIDTH = 12;
    protected static final int UPGRADE_BUTTON_HEIGHT = 12;
    private final float expLabelX;

    public CrystalGeneratorScreen(AbstractGeneratorContainerMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageHeight = 191;
        this.inventoryLabelY = this.imageHeight - 94;
        this.expLabelX = this.inventoryLabelX + 112;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture());
        guiGraphics.blit(this.texture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFire(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        int xOffset = (IntegerUtils.getDigits(((AbstractGeneratorContainerMenu)this.menu).getExp()) - 1) * 6 + (IntegerUtils.getDigits(((AbstractGeneratorContainerMenu)this.menu).getExpCap()) - 2) * 6;
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Exp: %d/%d", ((AbstractGeneratorContainerMenu)this.menu).getExp(), ((AbstractGeneratorContainerMenu)this.menu).getExpCap())), (int)(this.expLabelX - (float)xOffset), this.inventoryLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Generating %s FE/Tick", ((AbstractGeneratorContainerMenu)this.menu).getCurrentGeneration())), this.inventoryLabelX, 39, 0x404040, false);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new BlockEntityUpgradeButton(155 + this.leftPos, 6 + this.topPos, 12, 12, (Component)Component.literal((String)"+"), pButton -> {
            Screen toOpen = this.upgradeButtonScreen();
            if (toOpen == null) {
                CrystalTools.LOGGER.warn("Couldn't open upgrade button, no skill tree defined");
            } else {
                ModGUIs.openScreen(toOpen);
            }
        }, (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)(((AbstractGeneratorContainerMenu)this.menu).getSkillPoints() + " Point(s) Available"));
            guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, false));
        this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(this.leftPos + 8, this.topPos + 23, 160, 10, (Component)Component.empty(), this.font, (EnergyLevelableContainerMenu)this.menu));
    }

    protected Screen upgradeButtonScreen() {
        return new BlockEntityUpgradeScreen((LevelableContainerMenu)this.menu, ((AbstractGeneratorContainerMenu)this.menu).getPlayer(), (Screen)this);
    }

    protected ResourceLocation texture() {
        return TEXTURE;
    }

    protected int fireX() {
        return 82;
    }

    protected int fireY() {
        return 78;
    }

    private void renderFire(GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, this.leftPos + this.fireX(), this.topPos + this.fireY(), 190, 0, 14, 13);
        if (((AbstractGeneratorContainerMenu)this.menu).isLit()) {
            float litProgress = ((AbstractGeneratorContainerMenu)this.menu).getLitProgress();
            int height = (int)(litProgress * 13.0f);
            guiGraphics.blit(TEXTURE, this.leftPos + this.fireX(), this.topPos + this.fireY() + 13 - height, 176, 13 - height, 14, height);
        }
    }
}

