/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.willyelton.crystal_tools.client.gui.BackpackSubScreen;
import dev.willyelton.crystal_tools.client.gui.BlockEntityUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.FilterConfigScreen;
import dev.willyelton.crystal_tools.client.gui.ModGUIs;
import dev.willyelton.crystal_tools.client.gui.QuarrySettingsScreen;
import dev.willyelton.crystal_tools.client.gui.SubScreenContainerScreen;
import dev.willyelton.crystal_tools.client.gui.component.EnergyBarWidget;
import dev.willyelton.crystal_tools.client.gui.component.backpack.BackpackScreenButton;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalQuarryContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.EnergyLevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.LevelableContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.network.data.OpenContainerPayload;
import dev.willyelton.crystal_tools.utils.IntegerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrystalQuarryScreen
extends AbstractContainerScreen<CrystalQuarryContainerMenu>
implements SubScreenContainerScreen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/crystal_quarry.png");
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 23;
    private static final int ENERGY_WIDTH = 160;
    private static final int ENERGY_HEIGHT = 10;
    private final float expLabelX;
    private BackpackScreenButton skillTreeButton;

    public CrystalQuarryScreen(CrystalQuarryContainerMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageHeight = 227;
        this.inventoryLabelY = this.imageHeight - 97;
        this.expLabelX = this.inventoryLabelX + 112;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        int xOffset = (IntegerUtils.getDigits(((CrystalQuarryContainerMenu)this.menu).getExp()) - 1) * 6 + (IntegerUtils.getDigits(((CrystalQuarryContainerMenu)this.menu).getExpCap()) - 2) * 6;
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Exp: %d/%d", ((CrystalQuarryContainerMenu)this.menu).getExp(), ((CrystalQuarryContainerMenu)this.menu).getExpCap())), (int)(this.expLabelX - (float)xOffset), this.inventoryLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Using %s FE/Tick", ((CrystalQuarryContainerMenu)this.menu).getEnergyCost())), this.inventoryLabelX, 39, 0x404040, false);
        BlockPos miningAt = ((CrystalQuarryContainerMenu)this.menu).getMiningAt();
        guiGraphics.drawString(this.font, (Component)Component.literal((String)String.format("Mining At %d, %d, %d", miningAt.getX(), miningAt.getY(), miningAt.getZ())), this.inventoryLabelX, 49, 0x404040, false);
        this.skillTreeButton.setBadgeCounter(((CrystalQuarryContainerMenu)this.menu).getSkillPoints());
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(this.leftPos + 8, this.topPos + 23, 160, 10, (Component)Component.empty(), this.font, (EnergyLevelableContainerMenu)this.menu));
        int screenButtonY = this.topPos + 22;
        this.skillTreeButton = (BackpackScreenButton)this.addRenderableWidget((GuiEventListener)new BackpackScreenButton(this.leftPos - 21, screenButtonY, (Component)Component.literal((String)"Open Skill Tree"), button -> ModGUIs.openScreen(new BlockEntityUpgradeScreen((LevelableContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer(), () -> PacketDistributor.sendToServer((CustomPacketPayload)new OpenContainerPayload(((CrystalQuarryContainerMenu)this.menu).getBlockPos().asLong()), (CustomPacketPayload[])new CustomPacketPayload[0]))), (button, guiGraphics, mouseX, mouseY) -> {
            MutableComponent textComponent = Component.literal((String)"Open Skill Tree");
            guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)textComponent, Math.max(this.width / 2 - 43, 170)), mouseX, mouseY);
        }, 40));
        List subScreenButtons = this.getSideButtons(this.leftPos - 21, screenButtonY += 21, this.width, (SubScreenContainerMenu)this.menu);
        subScreenButtons.forEach(x$0 -> {
            BackpackScreenButton cfr_ignored_0 = (BackpackScreenButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    @Override
    public List<BackpackSubScreen<?, ?>> getSubScreens() {
        ArrayList subScreens = new ArrayList();
        if (((CrystalQuarryContainerMenu)this.menu).getFilterRows() > 0) {
            subScreens.add(new FilterConfigScreen<CrystalQuarryContainerMenu, CrystalQuarryScreen>(this, (CrystalQuarryContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer().getInventory(), this, (Component)Component.literal((String)"Trash Filter")){

                @Override
                public Component getButtonName() {
                    return Component.literal((String)"Configure Trash Filters");
                }
            });
        }
        subScreens.add(new QuarrySettingsScreen((CrystalQuarryContainerMenu)this.menu, ((CrystalQuarryContainerMenu)this.menu).getPlayer().getInventory(), this));
        return subScreens;
    }
}

