/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.BackpackSubScreen;
import dev.willyelton.crystal_tools.client.gui.CrystalBackpackScreen;
import dev.willyelton.crystal_tools.client.gui.component.backpack.ClearFilterButton;
import dev.willyelton.crystal_tools.client.gui.component.backpack.MatchContentsButton;
import dev.willyelton.crystal_tools.client.gui.component.backpack.WhitelistToggleButton;
import dev.willyelton.crystal_tools.common.inventory.container.BaseContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.FilterContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import dev.willyelton.crystal_tools.common.network.data.BackpackScreenPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FilterConfigScreen<T extends BaseContainerMenu & FilterContainerMenu, U extends Screen>
extends BackpackSubScreen<T, U> {
    private boolean whitelist;
    private final boolean showMatchBackpackButton;

    public FilterConfigScreen(T menu, Inventory playerInventory, U returnScreen, boolean showMatchBackpackButton) {
        this(menu, playerInventory, returnScreen, (Component)Component.literal((String)"Filter"), showMatchBackpackButton);
    }

    public FilterConfigScreen(T menu, Inventory playerInventory, U returnScreen, Component screenTitle) {
        this(menu, playerInventory, returnScreen, screenTitle, false);
    }

    public FilterConfigScreen(T menu, Inventory playerInventory, U returnScreen, Component screenTitle, boolean showMatchBackpackButton) {
        super(menu, playerInventory, screenTitle, returnScreen);
        this.showMatchBackpackButton = showMatchBackpackButton;
    }

    @Override
    protected void init() {
        super.init();
        this.whitelist = ((FilterContainerMenu)((Object)((BaseContainerMenu)this.menu))).getWhitelist();
        if (((FilterContainerMenu)((Object)((BaseContainerMenu)this.menu))).getFilterRows() > 0) {
            this.addRenderableWidget((GuiEventListener)new WhitelistToggleButton(this.leftPos + 157, this.topPos + 4, button -> {
                boolean bl = this.whitelist = !this.whitelist;
                if (button instanceof WhitelistToggleButton) {
                    WhitelistToggleButton toggleButton = (WhitelistToggleButton)button;
                    toggleButton.setWhitelist(this.whitelist);
                    ((FilterContainerMenu)((Object)((BaseContainerMenu)this.menu))).setWhitelist(this.whitelist);
                    BackpackScreenPayload.BackpackAction type = this.whitelist ? BackpackScreenPayload.BackpackAction.PICKUP_WHITELIST : BackpackScreenPayload.BackpackAction.PICKUP_BLACKLIST;
                    ((SubScreenContainerMenu)((Object)((BaseContainerMenu)this.menu))).sendUpdatePacket(type);
                }
            }, this.whitelist, (Screen)this));
            this.addRenderableWidget((GuiEventListener)new ClearFilterButton(this.leftPos + 143, this.topPos + 4, (Screen)this, (SubScreenContainerMenu)this.menu));
            if (this.showMatchBackpackButton) {
                this.addRenderableWidget((GuiEventListener)new MatchContentsButton(this.leftPos + 129, this.topPos + 4, (Screen)this, (SubScreenContainerMenu)this.menu));
            }
        }
    }

    @Override
    protected int getRowsToDraw() {
        return Math.min(((FilterContainerMenu)((Object)((BaseContainerMenu)this.menu))).getFilterRows(), this.getContainerRows());
    }

    @Override
    protected void drawContentRow(GuiGraphics guiGraphics, int row) {
        guiGraphics.blit(CrystalBackpackScreen.TEXTURE, this.leftPos, this.topPos + 17 + 18 * row, 0.0f, 222.0f, 176, 18, 512, 512);
    }

    @Override
    public Component getButtonName() {
        return Component.literal((String)"Configure Filters");
    }

    @Override
    public SubScreenType getType() {
        return SubScreenType.FILTER;
    }

    @Override
    public int getButtonTextureXOffset() {
        return 0;
    }
}

