/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.client.gui.CrystalGeneratorScreen;
import dev.willyelton.crystal_tools.client.gui.UpgradeScreen;
import dev.willyelton.crystal_tools.common.inventory.container.AbstractGeneratorContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.PortableGeneratorContainerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class PortableGeneratorScreen
extends CrystalGeneratorScreen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/gui/portable_generator.png");
    private static final int DISABLED_SLOT_TEXTURE_X = 176;
    private static final int DISABLED_SLOT_TEXTURE_Y = 13;
    private static final int DISABLED_SLOT_TEXTURE_SIZE = 18;
    private static final int TOTAL_SLOTS = 27;
    private final int activeSlots;
    private final ItemStack generatorStack;

    public PortableGeneratorScreen(AbstractGeneratorContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.imageHeight = 218;
        this.inventoryLabelY = this.imageHeight - 94;
        if (container instanceof PortableGeneratorContainerMenu) {
            PortableGeneratorContainerMenu portableGeneratorContainerMenu = (PortableGeneratorContainerMenu)container;
            this.activeSlots = portableGeneratorContainerMenu.getActiveSlots();
            this.generatorStack = portableGeneratorContainerMenu.getGeneratorStack();
        } else {
            this.activeSlots = 0;
            this.generatorStack = ItemStack.EMPTY;
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.renderDisabledSlots(guiGraphics);
    }

    @Override
    protected Screen upgradeButtonScreen() {
        return new UpgradeScreen(this.generatorStack, ((AbstractGeneratorContainerMenu)this.menu).getPlayer());
    }

    @Override
    protected ResourceLocation texture() {
        return TEXTURE;
    }

    @Override
    protected int fireY() {
        return 108;
    }

    protected void renderDisabledSlots(GuiGraphics guiGraphics) {
        for (int i = this.activeSlots; i < 27; ++i) {
            int x = i % 9;
            int y = i / 9;
            guiGraphics.blit(this.texture(), this.leftPos + 8 + x * 18 - 1, this.topPos + 52 + y * 18 - 1, 176.0f, 13.0f, 18, 18, 256, 256);
        }
    }
}

