/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.willyelton.crystal_tools.client.gui.BackpackSubScreen;
import dev.willyelton.crystal_tools.client.gui.CrystalBackpackScreen;
import dev.willyelton.crystal_tools.client.gui.CrystalQuarryScreen;
import dev.willyelton.crystal_tools.common.inventory.container.CrystalQuarryContainerMenu;
import dev.willyelton.crystal_tools.common.inventory.container.subscreen.SubScreenType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class QuarrySettingsScreen
extends BackpackSubScreen<CrystalQuarryContainerMenu, CrystalQuarryScreen> {
    private Checkbox silkTouchCheckbox;
    private Checkbox fortuneCheckbox;

    public QuarrySettingsScreen(CrystalQuarryContainerMenu menu, Inventory playerInventory, CrystalQuarryScreen returnScreen) {
        super(menu, playerInventory, (Component)Component.literal((String)"Quarry Settings"), returnScreen);
    }

    @Override
    protected void init() {
        super.init();
        int index = 0;
        this.addCheckbox("Fill With Dirt", "Causes the Quarry to fill in mined blocks with dirt", 0, index++);
        if (((CrystalQuarryContainerMenu)this.menu).shouldSettingBeActive(1)) {
            this.silkTouchCheckbox = this.addCheckbox("Enable Silk Touch", "Enables Silk Touch for the quarry", 1, index++);
        }
        if (((CrystalQuarryContainerMenu)this.menu).shouldSettingBeActive(2)) {
            this.fortuneCheckbox = this.addCheckbox("Enable Fortune", "Enables Fortune for the quarry", 2, index++);
        }
        if (((CrystalQuarryContainerMenu)this.menu).shouldSettingBeActive(3)) {
            this.addCheckbox("Enable Auto Output", "Enables Auto Output for the quarry", 3, index++);
        }
    }

    private Checkbox addCheckbox(String title, String tooltip, int buttonId, int index) {
        return (Checkbox)this.addRenderableWidget((GuiEventListener)this.fixCheckbox(Checkbox.builder((Component)Component.literal((String)title), (Font)this.font).pos(this.leftPos + 4, this.topPos + 20 + 20 * index).selected(((CrystalQuarryContainerMenu)this.menu).getSetting(buttonId)).tooltip(Tooltip.create((Component)Component.literal((String)tooltip))).onValueChange((checkbox, value) -> {
            ((CrystalQuarryContainerMenu)this.menu).setSetting(buttonId, value);
            if (buttonId == 1 && value) {
                ((CrystalQuarryContainerMenu)this.menu).setSetting(11, false);
                if (this.fortuneCheckbox != null) {
                    this.fortuneCheckbox.selected = false;
                }
            } else if (buttonId == 2 && value) {
                ((CrystalQuarryContainerMenu)this.menu).setSetting(10, false);
                if (this.silkTouchCheckbox != null) {
                    this.silkTouchCheckbox.selected = false;
                }
            }
            this.minecraft.gameMode.handleInventoryButtonClick(((CrystalQuarryContainerMenu)this.menu).containerId, buttonId);
        }).build()));
    }

    private Checkbox fixCheckbox(Checkbox checkbox) {
        checkbox.textWidget = new MultiLineTextWidget(this, checkbox.getMessage(), this.font){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                MultiLineLabel multilinelabel = (MultiLineLabel)this.cache.getValue((Object)this.getFreshCacheKey());
                int i = this.getX();
                int j = this.getY();
                int k = 9;
                int l = this.getColor();
                if (this.centered) {
                    multilinelabel.renderCentered(guiGraphics, i + this.getWidth() / 2, j, k, l);
                } else {
                    multilinelabel.renderLeftAlignedNoShadow(guiGraphics, i, j, k, l);
                }
            }
        }.setMaxWidth(checkbox.getWidth()).setColor(0x404040);
        return checkbox;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CrystalBackpackScreen.TEXTURE);
        this.drawTopBar(guiGraphics);
        for (int i = 0; i < 6; ++i) {
            this.drawEmptyRow(guiGraphics, i);
        }
        this.drawBottomBar(guiGraphics, this.topPos + 17 + 108);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    @Override
    protected int getRowsToDraw() {
        return 0;
    }

    @Override
    protected void drawContentRow(GuiGraphics guiGraphics, int row) {
    }

    @Override
    public Component getButtonName() {
        return Component.literal((String)"Quarry Settings");
    }

    @Override
    public SubScreenType getType() {
        return SubScreenType.SETTINGS;
    }

    @Override
    public int getButtonTextureXOffset() {
        return 60;
    }
}

