/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.gui;

import dev.willyelton.crystal_tools.Registration;
import dev.willyelton.crystal_tools.client.gui.BaseUpgradeScreen;
import dev.willyelton.crystal_tools.client.gui.component.SkillButton;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.CrystalBackpack;
import dev.willyelton.crystal_tools.common.levelable.skill.SkillDataNode;
import dev.willyelton.crystal_tools.common.network.data.ResetSkillsPayload;
import dev.willyelton.crystal_tools.common.network.data.ToolAttributePayload;
import dev.willyelton.crystal_tools.common.network.data.ToolHealPayload;
import dev.willyelton.crystal_tools.utils.ToolUtils;
import java.util.Set;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class UpgradeScreen
extends BaseUpgradeScreen {
    private Button healButton;
    private final ItemStack stack;
    private final Runnable onClose;
    private int slotIndex = -1;

    public UpgradeScreen(ItemStack itemStack, Player player) {
        this(itemStack, player, null);
    }

    public UpgradeScreen(int slotIndex, Player player, Runnable onClose) {
        this(CrystalBackpack.getBackpackFromSlotIndex(player, slotIndex), player, onClose);
        this.slotIndex = slotIndex;
    }

    public UpgradeScreen(ItemStack itemStack, Player player, Runnable onClose) {
        super(player, (Component)Component.literal((String)"Upgrade Screen"));
        this.stack = itemStack;
        this.data = ToolUtils.getSkillData(itemStack);
        this.onClose = onClose;
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.healButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Heal"), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)ToolHealPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, -1);
            this.updateButtons();
            button.active = false;
        }).bounds(5, 15, 30, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Uses a skill point to fully repair this tool"))).build());
    }

    @Override
    protected void resetPoints(boolean crystalRequired) {
        if (!crystalRequired || this.player.getInventory().hasAnyOf(Set.of((Item)Registration.CRYSTAL.get()))) {
            PacketDistributor.sendToServer((CustomPacketPayload)ResetSkillsPayload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            ToolUtils.resetPoints(this.stack);
            this.data = ToolUtils.getSkillData(this.stack);
        }
        this.onClose();
    }

    @Override
    protected int getSkillPoints() {
        return (Integer)this.stack.getOrDefault(DataComponents.SKILL_POINTS, (Object)0);
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        int skillPoints = this.getSkillPoints();
        this.healButton.active = skillPoints > 0 && this.stack.isDamaged();
    }

    @Override
    protected void onSkillButtonPress(SkillDataNode node, Button button) {
        int skillPoints = this.getSkillPoints();
        boolean shift = UpgradeScreen.hasShiftDown();
        boolean control = UpgradeScreen.hasControlDown();
        if (skillPoints > 0) {
            int pointsToSpend = 1;
            if (node.getLimit() == 0) {
                pointsToSpend = this.getPointsToSpend(skillPoints, shift, control);
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ToolAttributePayload(node.getKey(), node.getValue(), node.getId(), this.slotIndex, pointsToSpend), (CustomPacketPayload[])new CustomPacketPayload[0]);
            node.addPoint(pointsToSpend);
            if (node.isComplete()) {
                ((SkillButton)button).setComplete();
            }
            this.changeSkillPoints(-pointsToSpend);
        }
        super.onSkillButtonPress(node, button);
    }

    @Override
    protected void changeSkillPoints(int change) {
        DataComponents.addToComponent(this.stack, DataComponents.SKILL_POINTS, change);
        PacketDistributor.sendToServer((CustomPacketPayload)new ToolAttributePayload("skill_points", change, -1, this.slotIndex, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected int getXpButtonY() {
        return 35;
    }

    public void onClose() {
        super.onClose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }
}

