/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.willyelton.crystal_tools.Registration;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class CrystalElytraLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends ElytraLayer<T, M> {
    private static final ResourceLocation WINGS_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/entity/crystal_elytra.png");
    private final A chestModel;

    public CrystalElytraLayer(RenderLayerParent<T, M> renderer, EntityModelSet entityModelSet, A chestModel) {
        super(renderer, entityModelSet);
        this.chestModel = chestModel;
    }

    @NotNull
    public ResourceLocation getElytraTexture(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return WINGS_LOCATION;
    }

    public boolean shouldRender(ItemStack stack, @NotNull LivingEntity entity) {
        return stack.getItem() == Registration.CRYSTAL_ELYTRA.get();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack, (LivingEntity)livingEntity)) {
            this.renderArmorPiece(poseStack, buffer, livingEntity, EquipmentSlot.CHEST, packedLight, this.chestModel, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            super.render(poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, T livingEntity, EquipmentSlot slot, int packedLight, A model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = livingEntity.getItemBySlot(slot);
        ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
        model.setAllVisible(false);
        ((HumanoidModel)model).body.visible = true;
        ((HumanoidModel)model).rightArm.visible = true;
        ((HumanoidModel)model).leftArm.visible = true;
        ArmorMaterial armormaterial = (ArmorMaterial)ArmorMaterials.NETHERITE.value();
        IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)itemstack);
        extensions.setupModelAnimations(livingEntity, itemstack, slot, model, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
        int fallbackColor = extensions.getDefaultDyeColor(itemstack);
        for (int layerIdx = 0; layerIdx < armormaterial.layers().size(); ++layerIdx) {
            ArmorMaterial.Layer armormaterial$layer = (ArmorMaterial.Layer)armormaterial.layers().get(layerIdx);
            int j = extensions.getArmorLayerTintColor(itemstack, livingEntity, armormaterial$layer, layerIdx, fallbackColor);
            if (j == 0) continue;
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"textures/models/armor/crystal_layer_1.png");
            this.renderModel(poseStack, bufferSource, packedLight, (Model)model, j, texture);
        }
    }

    private void renderModel(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, Model p_289658_, int p_350798_, ResourceLocation p_324344_) {
        VertexConsumer vertexconsumer = p_289689_.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)p_324344_));
        p_289658_.renderToBuffer(p_289664_, vertexconsumer, p_289681_, OverlayTexture.NO_OVERLAY, p_350798_);
    }
}

