/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.particle.quarry.breakblock;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class QuarryBreakParticle
extends TerrainParticle {
    private final double xf;
    private final double yf;
    private final double zf;
    private final double initialX;
    private final double initialY;
    private final double initialZ;

    public QuarryBreakParticle(ClientLevel level, double x, double y, double z, double xf, double yf, double zf, BlockState state) {
        super(level, x, y, z, 0.0, 0.0, 0.0, state);
        this.gravity = 0.0f;
        this.xf = xf + 0.5 + this.random.nextGaussian() * 0.1;
        this.yf = yf + 0.5;
        this.zf = zf + 0.5 + this.random.nextGaussian() * 0.1;
        this.initialX = x;
        this.initialY = y;
        this.initialZ = z;
        this.lifetime = (int)Mth.length((double)(xf - x), (double)(yf - y), (double)(zf - z)) * 4 + 1;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            double timeFraction = (double)this.age / (double)this.lifetime;
            this.move(this.dx(timeFraction) - this.xo, this.dy(timeFraction) - this.yo, this.dz(timeFraction) - this.zo);
        }
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    private double dx(double time) {
        return Mth.lerp((double)time, (double)this.initialX, (double)this.xf);
    }

    private double dy(double time) {
        return (time - 12.5) * (time - 1.36) * (time + 3.5) * (time + 0.9) * time * (this.yf - this.initialY) / 35.6 + this.initialY;
    }

    private double dz(double time) {
        return Mth.lerp((double)time, (double)this.initialZ, (double)this.zf);
    }
}

