/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.client.renderer.CrystalToolsRenderTypes;
import dev.willyelton.crystal_tools.common.levelable.tool.HoeLevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.LevelableTool;
import dev.willyelton.crystal_tools.common.levelable.tool.VeinMinerLevelableTool;
import dev.willyelton.crystal_tools.utils.BlockCollectors;
import dev.willyelton.crystal_tools.utils.RayTraceUtils;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class BlockOverlayRenderer {
    public static void render3x3(RenderLevelStageEvent event, LevelableTool toolItem, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player != null && level != null) {
            List<BlockPos> blockPosCollection;
            MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
            Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
            BlockHitResult hitResult = RayTraceUtils.rayTrace((LivingEntity)player);
            if (level.getBlockState(hitResult.getBlockPos()).isAir()) {
                return;
            }
            BlockPos pos = hitResult.getBlockPos();
            BlockState hitBlockState = level.getBlockState(pos);
            PoseStack pose = event.getPoseStack();
            pose.pushPose();
            pose.translate(-view.x, -view.y, -view.z);
            VertexConsumer builder = buffer.getBuffer(CrystalToolsRenderTypes.BLOCK_OVERLAY);
            boolean hoe = false;
            if (toolItem instanceof HoeLevelableTool && !hitBlockState.is(BlockTags.MINEABLE_WITH_HOE)) {
                blockPosCollection = BlockCollectors.collect3x3Hoe(pos);
                hoe = true;
            } else {
                blockPosCollection = BlockCollectors.collect3x3(pos, hitResult.getDirection());
            }
            for (BlockPos renderPos : blockPosCollection) {
                BlockState state = level.getBlockState(renderPos);
                if (state.isAir() || !toolItem.correctTool(stack, state) && !hoe) continue;
                BlockOverlayRenderer.renderBlockPos(pose, builder, renderPos, 0.31686276f, 0.37058824f, 0.36156863f);
            }
            pose.popPose();
        }
    }

    public static void renderVeinMiner(RenderLevelStageEvent event, VeinMinerLevelableTool toolItem, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player != null && level != null) {
            MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
            Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
            BlockHitResult hitResult = RayTraceUtils.rayTrace((LivingEntity)player);
            if (level.getBlockState(hitResult.getBlockPos()).isAir()) {
                return;
            }
            BlockPos pos = hitResult.getBlockPos();
            BlockState hitBlockState = level.getBlockState(pos);
            if (!toolItem.canVeinMin(stack, hitBlockState)) {
                return;
            }
            PoseStack pose = event.getPoseStack();
            pose.pushPose();
            pose.translate(-view.x, -view.y, -view.z);
            VertexConsumer builder = buffer.getBuffer(CrystalToolsRenderTypes.BLOCK_OVERLAY);
            Collection<BlockPos> blockPosCollection = BlockCollectors.collectVeinMine(pos, (Level)level, toolItem.getVeinMinerPredicate(hitBlockState), toolItem.getMaxBlocks(stack));
            for (BlockPos renderPos : blockPosCollection) {
                BlockState state = level.getBlockState(renderPos);
                if (state.isAir()) continue;
                BlockOverlayRenderer.renderBlockPos(pose, builder, renderPos, 0.31686276f, 0.37058824f, 0.36156863f);
            }
            pose.popPose();
        }
    }

    public static void renderBlockPos(PoseStack pose, MultiBufferSource bufferSource, BlockPos pos, int color) {
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        pose.pushPose();
        pose.translate(-view.x, -view.y, -view.z);
        BlockOverlayRenderer.renderBlockPos(pose, bufferSource.getBuffer(CrystalToolsRenderTypes.BLOCK_OVERLAY), pos, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        pose.popPose();
    }

    public static void renderBlockPos(PoseStack pose, VertexConsumer builder, BlockPos pos, float red, float green, float blue) {
        float alpha = 0.5f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        pose.pushPose();
        pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        pose.translate(-5.0E-4f, -5.0E-4f, -5.0E-4f);
        pose.scale(1.001f, 1.001f, 1.001f);
        pose.mulPose(Axis.YP.rotationDegrees(-90.0f));
        Matrix4f matrix = pose.last().pose();
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, startX, endY, startZ).setColor(red, green, blue, alpha);
        pose.popPose();
    }
}

