/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class CrystalShieldRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final CrystalShieldRenderer INSTANCE = new CrystalShieldRenderer();
    private static final Material SHIELD_MATERIAL = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"entity/crystal_shield"));
    private ShieldModel shieldModel;
    private final EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();

    public CrystalShieldRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.shieldModel = new ShieldModel(this.entityModelSet.bakeLayer(ModelLayers.SHIELD));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BannerPatternLayers bannerpatternlayers = (BannerPatternLayers)stack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        DyeColor dyecolor = (DyeColor)stack.get(DataComponents.BASE_COLOR);
        boolean hasBanner = !bannerpatternlayers.layers().isEmpty() || dyecolor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material material = SHIELD_MATERIAL;
        VertexConsumer vertexconsumer = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.shieldModel.renderType(material.atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
        this.shieldModel.handle().render(poseStack, vertexconsumer, packedLight, packedOverlay);
        if (hasBanner) {
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (int)packedOverlay, (ModelPart)this.shieldModel.plate(), (Material)material, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyecolor, DyeColor.WHITE), (BannerPatternLayers)bannerpatternlayers, (boolean)stack.hasFoil());
        } else {
            this.shieldModel.plate().render(poseStack, vertexconsumer, packedLight, packedOverlay);
        }
        poseStack.popPose();
    }
}

