/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.willyelton.crystal_tools.client.renderer.CrystalTridentRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CrystalTridentBlockEntityWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final CrystalTridentBlockEntityWithoutLevelRenderer INSTANCE = new CrystalTridentBlockEntityWithoutLevelRenderer();
    public static final ModelResourceLocation CRYSTAL_TRIDENT_MODEL_RESOURCE_LOCATION = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystal_tools", (String)"item/crystal_trident_inventory"));
    private final EntityModelSet entityModelSet = Minecraft.getInstance().getEntityModels();
    private TridentModel crystalTridentModel;

    public CrystalTridentBlockEntityWithoutLevelRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.crystalTridentModel = new TridentModel(this.entityModelSet.bakeLayer(ModelLayers.TRIDENT));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.GROUND || displayContext == ItemDisplayContext.FIXED) {
            poseStack.popPose();
            poseStack.pushPose();
            if (displayContext == ItemDisplayContext.GROUND) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0, 0.25, 0.0);
            }
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel inventoryModel = Minecraft.getInstance().getModelManager().getModel(CRYSTAL_TRIDENT_MODEL_RESOURCE_LOCATION);
            for (BakedModel model : inventoryModel.getRenderPasses(stack, false)) {
                for (RenderType renderType : model.getRenderTypes(stack, false)) {
                    VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
                    itemRenderer.renderModelLists(model, stack, packedLight, packedOverlay, poseStack, vertexConsumer);
                }
            }
        } else {
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer vertexconsumer1 = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.crystalTridentModel.renderType(CrystalTridentRenderer.CRYSTAL_TRIDENT_LOCATION), (boolean)false, (boolean)stack.hasFoil());
            this.crystalTridentModel.renderToBuffer(poseStack, vertexconsumer1, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

