/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.willyelton.crystal_tools.common.levelable.block.CrystalPedestalBlock;
import dev.willyelton.crystal_tools.common.levelable.block.entity.CrystalPedestalBlockEntity;
import dev.willyelton.crystal_tools.common.levelable.block.entity.data.PedestalClientData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CrystalPedestalBlockEntityRenderer
implements BlockEntityRenderer<CrystalPedestalBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.create();

    public CrystalPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(CrystalPedestalBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack itemstack;
        Level level = blockEntity.getLevel();
        if (level != null && (itemstack = blockEntity.getStack()) != null && !itemstack.isEmpty()) {
            itemstack = itemstack.copy();
            itemstack.setCount(1);
            PedestalClientData clientData = blockEntity.getClientData();
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.rotateAround(((Direction)blockEntity.getBlockState().getValue(CrystalPedestalBlock.FACING)).getRotation(), 0.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.rotLerp((float)partialTick, (float)clientData.previousRot(), (float)clientData.currentRot())));
            poseStack.translate(0.0f, Mth.lerp((float)partialTick, (float)clientData.previousHeight(), (float)clientData.currentHeight()), 0.0f);
            ItemEntityRenderer.renderMultipleFromCount((ItemRenderer)this.itemRenderer, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (ItemStack)itemstack, (RandomSource)this.random, (Level)level);
            poseStack.popPose();
        }
    }
}

