/*
 * Decompiled with CFR 0.152.
 */
package dev.willyelton.crystal_tools.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.willyelton.crystal_tools.common.components.DataComponents;
import dev.willyelton.crystal_tools.common.levelable.LevelableItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AddPointsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder addPointsCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add_points").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(commandContext -> AddPointsCommand.addPointsToTool((CommandContext<CommandSourceStack>)commandContext, IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"points"))));
        dispatcher.register(addPointsCommand);
    }

    static int addPointsToTool(CommandContext<CommandSourceStack> commandContext, int points) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)commandContext.getSource()).getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getHandSlots().forEach(itemStack -> {
                if (itemStack.getItem() instanceof LevelableItem) {
                    DataComponents.addToComponent(itemStack, DataComponents.SKILL_POINTS, points);
                }
            });
        }
        return 1;
    }
}

